# Modeling Heterogeneous Hierarchies with Relation-specific Hyperbolic Cones
**Introduction**

This is the PyTorch implementation of the ConE model based on the code framework provided by [RotatE] model (https://openreview.net/forum?id=HkgEQnRqYQ) for knowledge graph embedding (KGE). 

**Implemented features**

Models:
 - [x] RotatE
 - [x] pRotatE
 - [x] TransE
 - [x] ComplEx
 - [x] DistMult
 - [x] RotC
 - [x] ConE

Evaluation Metrics:

 - Knowledge graph completion:
    - [x] MRR, MR, HITS@1, HITS@3, HITS@10 (filtered)
    - [x] AUC-PR (for Countries data sets)
 - Ancestor-descendant prediction:
    - [x] mAP, AUROC
 - LCA prediction:
    - [x] HITS@1, HITS@3, HITS@10

Loss Function:

 - [x] Uniform Negative Sampling
 - [x] Self-Adversarial Negative Sampling
 - [x] Cone angle loss

**Usage**

Knowledge Graph Data:
 - *entities.dict*: a dictionary map entities to unique ids
 - *relations.dict*: a dictionary map relations to unique ids
 - *relation_category.txt*: a dictionary map relations to their type (1-1 indicates non-hierarchical, 1-M indicates hyponym, M-1 indicates hypernym)
 - *train.txt*: the KGE model is trained to fit this data set
 - *valid.txt*: create a blank file if no validation data is available
 - *test.txt*: the KGE model is evaluated on this data set
 - *lca_test_X*: LCA prediction under X-hop is evaluated on this data set
 - *class_test_X*: Test data for ancestor-prediction task, X=easy: 0% inferred pairs, X=medium: 50% inferred pairs, X=hard: 100% inferred pairs

**Train**

For example, this command train a RotatE model on FB15k dataset with GPU 0.
```
CUDA_VISIBLE_DEVICES=0 python -u codes/run.py --do_train \
 --cuda \
 --do_valid \
 --do_test \
 --data_path data/FB15k \
 --model RotatE \
 -n 256 -b 1024 -d 1000 \
 -g 24.0 -a 1.0 -adv \
 -lr 0.0001 --max_steps 150000 \
 -save models/RotatE_FB15k_0 --test_batch_size 16 -de
```
   Check argparse configuration at codes/run.py for more arguments and more details.

**Test**

    CUDA_VISIBLE_DEVICES=$GPU_DEVICE python -u $CODE_PATH/run.py --do_test --cuda -init $SAVE

**Reproducing the best results**

Three scripts (WN18RR.sh, DDB14.sh, GO21.sh) are provided in order to reproduce our results in the paper.

The run.sh script provides an easy way to search hyper-parameters:

    bash run.sh train RotatE FB15k 0 0 1024 256 1000 24.0 1.0 0.0001 200000 16 -de
    bash run.sh $MODE $MODEL $DATASET $GPU_DEVICE $SAVE_ID $BATCH_SIZE $NEGATIVE_SAMPLE_SIZE $HIDDEN_DIM 
    $GAMMA $ALPHA $LEARNING_RATE $MAX_STEPS $TEST_BATCH_SIZE 

**Using the library**

The python libarary is organized around 3 objects:

 - TrainDataset (dataloader.py): prepare data stream for training
 - TestDataSet (dataloader.py): prepare data stream for evluation
 - KGEModel (model.py): calculate triple score and provide train/test API

The run.py file contains the main function, which parses arguments, reads data, initilize the model and provides the training loop.

Add your own model to model.py like:
```
def TransE(self, head, relation, tail, mode):
    if mode == 'head-batch':
        score = head + (relation - tail)
    else:
        score = (head + relation) - tail

    score = self.gamma.item() - torch.norm(score, p=1, dim=2)
    return score
```

