# Repro Code Package for "Hyper Hawkes Process".
ICLR 2026 Submission Number 14345

**Note**: This code is intended to be ran in a Google Colab notebook for portability and reproducibility.

This repro optimized for reproduction of the interpretability experiments, because we can easily distribute checkpoints and data. The attached notebook will reproduce all the interpretability experiments presented in Section 6.

## To Reproduce Interpretability Experiments.

1. Start a Colab instance.  CPU instance is fine.
2. Open `HHP-Interp-Repro.ipynb` in Colab.
3. Upload `hhp-iclr2026-code.zip` to `/content/hhp-iclr2026-code.zip` in that Colab.
4. Follow the instructions in the first section of the notebook.

## To Train a New Model.
Our code is fully integrated with the EasyTPP library.  Please familiarize yourself with their configuration, data downloading, data loading, evaluation pipeline etc prior to running this code. 

1. Follow the installation steps for the interpretability repo.
2. Follow the EasyTPP download process for the dataset you wish to train on.  (We do not vend the datasets here for consistency and licensing.)
3. Once downloaded, run the following code with the appropriate configuration selected: 
```bash
%cd /content/hhp-iclr2026/hyper-hawkes-process/EasyTPP
!python ./examples/train_hhp.py --config_dir /content/hhp-iclr2026/hyper-hawkes-process/EasyTPP/examples/configs/exp_config_taxi.yaml
```


