import truststore

truststore.inject_into_ssl()

import argparse

from easy_tpp.config_factory import Config
from easy_tpp.runner import Runner


def main():
    parser = argparse.ArgumentParser()

    parser.add_argument(
        "--config_dir",
        type=str,
        required=False,
        default="/content/hhp-iclr2026/hyper-hawkes-process/EasyTPP/examples/configs/exp_config_taxi.yaml",
        help="Dir of configuration yaml to train and evaluate the model.",
    )

    parser.add_argument(
        "--experiment_id",
        type=str,
        required=False,
        default="HHP_train",
        help="Experiment id in the config file.",
    )

    args = parser.parse_args()

    config = Config.build_from_yaml_file(args.config_dir, experiment_id=args.experiment_id)

    model_runner = Runner.build_from_config(config)

    res = model_runner.run()
    print(res)


if __name__ == "__main__":
    main()
