import torch
from PIL import Image

HU_MAX = 80.0


def _attenuation_to_HU(image, scale_only=False):
    """
    scale_only == False:
    μ = (HU + 1000) * 0.1 / 1000

    scale_only == True:
    μ = HU * 0.1 / 1000
    """
    if scale_only:
        return image * 1000.0 / 0.1
    else:
        return (image * 1000.0 / 0.1) - 1000.0


def brain_hu(x):
    # map to HU
    hu_x = _attenuation_to_HU(x).cpu()

    # clone HU image and zero out whats outside of brain range
    hu_x_brain = hu_x.clone()

    # clamp to brain range
    hu_x_brain = torch.clamp(hu_x_brain, min=0.0, max=80.0)

    # scale to [0, 1]
    return hu_x_brain / HU_MAX
