# LadderySym 

**Music Error Detection Using Multimodal Interleaved Transformers**  
*Anonymous Submission*


## How to Run

Clone the repository and set up the environment:
```bash
git clone <repository-url>
cd LadderySym
conda env create -n LadderySym python==3.XX
conda activate LadderySym
```

## Environment Setup

Ensure you have the correct environment configuration:
- Install Python 3.XX
- Create and activate the Conda environment:
  ```bash
  conda env create -n LadderySym python==3.11
  conda activate LadderySym
  ```
- Install the required dependencies (via pip):
  ```bash
  pip install -r requirements.txt
  ```

Training:
```bash
python train_laddersym.py \
  --config-path="config" \
  --config-name="config_maestro/coco" \
  'devices=[0]' \
  'hydra/job_logging=disabled' \
  'model="laddersymNet"' \
  'dataset="MAESTRO/CocoChorales"' \
  'split_frame_length=2000'
```

Evaluation:
```bash
python test_laddersym.py \
  --config-dir="config" \
  --config-name="config_maestro/coco" \
  model="laddersymNet" \
  path="pretrained.ckpt" \
  eval.eval_dataset="MAESTRO/CocoChorales" \
  eval.exp_tag_name="LadderSym" \
  hydra/job_logging=disabled \
  eval.is_sanity_check=True \
  eval.contiguous_inference=True \
  split_frame_length=2000
```

Inference:
```bash
python laddersym_test_inference.py \
  --config-dir="config" \
  --config-name="config_maestro" \
  model="laddersymNet" \
  path="pretrained.ckpt" \
  hydra/job_logging=disabled \
  eval.is_sanity_check=True \
  eval.contiguous_inference=True \
  split_frame_length=2000
```
## Interpeting Outputs

The output is a MIDI file containing three tracks:

- Track 1: Extra notes
- Track 2: Missing notes
- Track 3: Correct notes

## Datasets
These are from the original Polytune paper:
- CocoChorales-E: [link](https://app.globus.org/file-manager?origin_id=55272af5-6d96-4381-a3ea-8d7197e57b33&origin_path=%2F)
- MAESTRO-E: [link](https://app.globus.org/file-manager?origin_id=63862b12-9f93-4f7c-ad7b-5a14ab5d1af2&origin_path=%2F)

- Downloading this dataset requires [Globus](https://www.globus.org) or [Globus Connect Personal](https://www.globus.org/globus-connect-personal).

1. Log in and follow setup instructions  
2. Go to the dataset link 
3. Click **“Transfer or Sync to…”**  
4. Choose your machine or HPC endpoint as the destination

