import os

if "PYRITE_HARDWARE_CONFIG_FOLDERS" not in os.environ:
    raise ValueError(
        "Please set the environment variable PYRITE_HARDWARE_CONFIG_FOLDERS"
    )
if "PYRITE_DATASET_FOLDERS" not in os.environ:
    raise ValueError("Please set the environment variable PYRITE_DATASET_FOLDERS")
if "PYRITE_CONTROL_LOG_FOLDERS" not in os.environ:
    raise ValueError("Please set the environment variable PYRITE_CONTROL_LOG_FOLDERS")

hardware_config_folder_path = os.environ.get("PYRITE_HARDWARE_CONFIG_FOLDERS")
data_folder_path = os.environ.get("PYRITE_DATASET_FOLDERS")

run_learner_on_server = False

control_para = {
    "raw_time_step_s": 0.002,
    "slow_down_factor": 1,
    "sparse_execution_horizon": 12,
    "delay_tolerance_s": 0.3,
    "max_duration_s": 3500,
    "test_nominal_target": False,
    "translational_stiffness": [1000, 1000, 1000],
    "rotational_stiffness": 70,
    "send_transitions_to_server": False,
    "fix_orientation": False,
    "pausing_mode": False,
    "no_visual_mode": False,
    "device": "cuda",
    "scale_and_cap_residual_action": False,
    "residual_action_scale_ratio": 0.3,
}
hardware_para = {
    "hardware_config_path": hardware_config_folder_path + "/belt_assembly.yaml",
}

learner_para = {
    # if residual_ckpt_path is specified and points to a valid checkpoint, the residual learner will load the checkpoint
    # However, currently the new checkpoints will still be saved to a new folder
    # "residual_ckpt_path": None,
    "residual_ckpt_path": "/2025.05.12_22.19.39_belt_residual_online_residual_mlp",


    "num_episodes_before_first_training": 50,
    "num_of_initial_episodes": 0, # first n episodes, both correction and no correction data are used
    "num_of_new_episodes": 0, # last n episodes to sample 50% from. set to 0 to disable
}

online_learning_para = {
    "data_folder_path": data_folder_path + "/online_belt_v3/",
    "policy_workspace_config_name": "train_online_residual_mlp_workspace",
    "transformers": False,
    "network_weight_topic": "network_weights_topic",
    "transitions_topic": "transitions_topic",
    "network_weight_expire_time_s": 1200,
    "transitions_topic_expire_time_s": 1200,
}
if run_learner_on_server:
    online_learning_para["network_server_endpoint"] = "tcp://localhost:18889"
    online_learning_para["transitions_server_endpoint"] = "tcp://localhost:18888"
else:
    online_learning_para["network_server_endpoint"] = "ipc:///tmp/feeds/2"
    online_learning_para["transitions_server_endpoint"] = "ipc:///tmp/feeds/3"