#!/bin/bash
# Script to convert multiple videos to JPG frames

# Update your data dir here
DATA_DIR=""
VIDEO_DIR="${DATA_DIR}/videos"
OUTPUT_DIR="${DATA_DIR}/masked_images"
FPS=3

for video_file in ${VIDEO_DIR}/*.mp4; do
    # Extract video file name without extension
    video_name=$(basename -- "$video_file")
    video_name="${video_name%.*}"

    # Create output directory
    output_dir="${OUTPUT_DIR}/${video_name}"
    mkdir -p "${output_dir}"

    # Convert video to JPG frames
    ffmpeg -i "${video_file}" -vf "fps=${FPS}" -q:v 2 -start_number 0 "${output_dir}/%05d.jpg"
done