import matplotlib.pyplot as plt
import numpy as np

# Years from 1990 to 2020
years = np.arange(1990, 2021)

# Original data for celestial body discoveries
exoplanets_discovered = np.array([
    0, 1, 0, 2, 5, 10, 8, 15, 20, 18, 25, 30, 40, 55, 60, 65, 70, 90, 100, 150, 200, 250, 300, 350, 400, 450, 500, 550, 600, 650, 700
])
moons_discovered = np.array([
    2, 3, 5, 8, 9, 12, 15, 18, 21, 25, 30, 35, 38, 40, 42, 50, 55, 57, 60, 65, 70, 75, 80, 85, 90, 95, 100, 110, 115, 120, 125
])
comets_discovered = np.array([
    10, 12, 15, 18, 20, 25, 28, 30, 35, 38, 40, 42, 45, 50, 55, 57, 60, 65, 68, 70, 75, 80, 82, 85, 90, 95, 100, 105, 110, 115, 120
])

# Calculate year-over-year differences
exoplanets_diff = np.diff(exoplanets_discovered, prepend=0)
moons_diff = np.diff(moons_discovered, prepend=0)
comets_diff = np.diff(comets_discovered, prepend=0)

# Create the subplot layout
fig, axs = plt.subplots(nrows=1, ncols=2, figsize=(18, 7))

# Plot the line chart on the first subplot
axs[0].plot(years, exoplanets_discovered, label='Exoplanets', color='navy', marker='o', linewidth=2, linestyle='-')
axs[0].plot(years, moons_discovered, label='Moons', color='olive', marker='s', linewidth=2, linestyle='--')
axs[0].plot(years, comets_discovered, label='Comets', color='teal', marker='^', linewidth=2, linestyle='-.')

# Set labels and title for the first subplot
axs[0].set_xlabel('Year', fontsize=12)
axs[0].set_ylabel('Number of Discoveries', fontsize=12)
axs[0].set_title('Cosmic Revelations:\nSpace Discoveries (1990-2020)', fontsize=14, fontweight='bold')
axs[0].grid(True, linestyle='--', alpha=0.5)
axs[0].legend(title='Celestial Bodies', loc='upper left', fontsize=10)

# Plot a bar chart on the second subplot for year-over-year differences
axs[1].bar(years - 0.2, exoplanets_diff, width=0.2, label='Exoplanets Δ', color='navy', alpha=0.7)
axs[1].bar(years, moons_diff, width=0.2, label='Moons Δ', color='olive', alpha=0.7)
axs[1].bar(years + 0.2, comets_diff, width=0.2, label='Comets Δ', color='teal', alpha=0.7)

# Set labels and subtitle for the second subplot
axs[1].set_xlabel('Year', fontsize=12)
axs[1].set_ylabel('Yearly Change in Discoveries', fontsize=12)
axs[1].set_title('Annual Discovery Fluctuations', fontsize=14, fontweight='bold')
axs[1].legend(loc='upper left', fontsize=10)
axs[1].grid(True, linestyle='--', alpha=0.5)

# Adjust layout to prevent text overlap
plt.tight_layout()

# Display the plot
plt.show()