# PROPGCL

The code is based on the paper [Rethinking and Scaling Up Graph Contrastive Learning: An Extremely Efficient Approach with Group Discrimination](https://arxiv.org/abs/2206.01535)

## Environment requirement

```bash
dgl                     0.7.1
networkx                2.6.2
numpy                   1.22.3
ogb                     1.3.2
scikit-learn            0.24.2
torch                   1.9.0
torch-cluster           1.5.9
torch-geometric         2.0.4
torch-scatter           2.0.8
torch-sparse            0.6.12
torch-spline-conv       1.2.1
torchmetrics            0.5.1
```

## Running


For PROP-GGD on ogbn-arxiv, you can run  `grace.py` by assigning the `--gnn_encoder` argument with `chebnet`, *i.e.*,

``` bash
python3 ggd_arxiv.py --dataset_name 'ogbn-arxiv' --dataset=ogbn-arxiv --ggd-lr 0.0001 --n-hidden 256 --n-layers 3 --proj_layers 1 --gnn_encoder 'chebnet' --n-ggd-epochs 1 
```

Similarly, for PROP-GGD on ogbn-products, you can run with

``` bash
python3 ggd_products.py --dataset_name 'ogbn-products' --dataset=ogbn-products --n-classifier-epochs 3000 --self-loop --ggd-lr 0.0001 --n-hidden 1024 --n-layers 4 --proj_layers 4 --gnn_encoder 'chebnet' --n-ggd-epochs 1
```
