# Image Super-Resolution with Guarantees via Conformal Generative Models

This is the code for the paper "Image Super-Resolution with Guarantees via Conformalized Generative Models"

## Requirements

The code is written in Python 3.11. To install the required packages, run:

```
pip install -r requirements.txt
```

We recommend using a package manager such as `poetry` or `conda` to manage the dependencies, we also include a `pyproject.toml` file for this purpose.

## Usage

To generate the figures in the paper, run:

```
bash generate_all_imgs.sh
```

Or

```
python -m src.fig$
```

where `$` is the figure number.

The conformal generative model is implemented in `src/base_model.py` and `src/conformal.py`. The code for calibrating is in `src/calibrate.py`.

Some of the figures depend on the data produced by the `calculate_*.py` scripts, we recommend running them first.

These scripts are supplied by masks that were generated using the code in `src/generate_masks_jax.py`.

Also, the implemenation of SinSR used is available in [this repository](https://github.com/wyf0912/SinSR).

Notice that there are some constants for the paths in the code that you may need to change.

---

The `*_col.py` are variations for the color-restoration model example for the supplementary material.

The implementation of DDColor used is available in [this repository](https://github.com/piddnad/DDColor/tree/master).
