%% Experimental setup dervied from http://proceedings.mlr.press/v37/yangd15.pdf (Page 7)

function [A, data_cov, X] = generate_data(n,d,s,f,noise_var)
    % Returns - 
    % 1. A - mixing matrix of size (d,d)
    % 2. data_cov - data covariance matrix of shape (d,d)
    % 3. X - data of shape (n,d)

    if(nargin == 0)
        n = 1000; % Number of datapoints
        d = 1000; % Dimensionality
        s = 10;   % Number of dimensions turned on
        noise_var = 0.5;
    end

    assert(s <= d); % Assert that s should be less than d
    
    % v1 = zeros(d,1); 
    % for i=1:s
    %     v1(i) = i;
    % end
    % v1 = v1/norm(v1);

    v1 = zeros(d,1); v1(1:s) = 1; v1 = v1/norm(v1);

    v2 = zeros(d,1); v2(s+1:(s+5)) = 1; v2 = v2/norm(v2);
    % v2 = zeros(d,1);

    % v2 = zeros(d,1); v2(s+1:100) = 1; v2 = v2/norm(v2);

    % v1 = randn(d,1); v1(s+1:end) = 0; v1 = v1/norm(v1);
    % v2 = randn(d,1); v2(1:s) = 0; v2(2*s+1:end) = 0; v2 = v2/norm(v2);

    % v1 = rand(d,1); v1(v1 < 0.5) = -1; v1(v1 >= 0.5) = 1; 
    % v1(s+1:end) = 0; v1 = v1/norm(v1);
    % v2 = rand(d,1); v2(v2 < 0.5) = -1; v2(v2 >= 0.5) = 1;
    % v2(1:s) = 0; v2(2*s+1:end) = 0; v2 = v2/norm(v2);
    
    lambda1 = 10;
    lambda2 = 5;
    A = real(sqrtm(lambda1*(v1*v1') + lambda2*(v2*v2')));
    % A = real(sqrtm(lambda1*(v1*v1')));
    % A = sqrt(lambda1)*(v1*v1');
    z = randn(d,n);
    % z = 2*sqrt(3)*(rand(d,n)-0.5);

    % p = 0.2;
    % z = (rand(d,n)<p);
    % z = z/sqrt(p*(1-p));
    noise = randn(d,n)*sqrt(noise_var);
    % noise = 2*sqrt(3)*(rand(d,n)-0.5)*sqrt(noise_var);

    % U = randn(d,d);
    % noise_cov = noise_var*(1/d)*(U*U');
    % noise = mvnrnd(zeros(d,1), noise_cov, n);
    X = A*z + noise;
    % X = mvnrnd(zeros(d,1), lambda1*(v1*v1'), n);
    % keyboard;
    % X = mvnrnd(zeros(d,1), eye(d), n);
    X = X';

    % data_cov = lambda1*(v1*v1') + noise_var*eye(d);
    data_cov = A*A' + noise_var*eye(d);
    % data_cov = eye(d);
    % data_cov = lambda1*(v1*v1');
    % data_cov = A*A';
    % data_cov = A*A' + noise_cov;

    % v = 1:d;
    % one_vector = ones(d,1);
    % M = abs(v'*one_vector' - one_vector*v);
    % beta = 2;
    % data_cov = exp(-M/beta);
    % X = mvnrnd(zeros(d,1),data_cov,n);
    
    % keyboard;
    % imagesc(data_cov);
    sample_cov = cov(X);

    % fprintf("Norm of difference of sample and population covariance " + ...
    %     "- %.5f\n", norm(sample_cov - data_cov));

    % %% Gaussian Mixture Model Data
    % sigmas = ones(d,1);
    % sigmas(1) = 100;
    % indices = randi([1 d],1,n);
    % X = zeros(n,d);
    % for i=1:n
    %     X(i,indices(i)) = randn(1,1)*sqrt(d)*sigmas(indices(i));
    % end
    % sample_cov = cov(X);
    % data_cov = diag(sigmas.^2);
end




