%% Experimental setup dervied from http://proceedings.mlr.press/v37/yangd15.pdf (Page 7)

function [data_cov, X] = generate_data_jing_lei(n,p,d1,d2)
    % Returns - 
    % 2. data_cov - data covariance matrix of shape (d,d)
    % 3. X - data of shape (n,d)

    if(nargin == 0)
        p = 100; % Number of datapoints
        d1 = 20; % Dimensionality
        d2 = 10;   % Number of dimensions turned on
    end
    
    U = zeros(p,p);
    U(1:d1,1) = unifrnd(0.9, 1.1, d1,1);
    U(d1+1:p,1) = 0;
    U(d1+1:d1+d2,2) = unifrnd(0.9, 1.1, d2,1);
    U(1:p,3:p) = randn(p,p-2);

    [Q,~] = qr(U);

    Lambda = unifrnd(0,2,p,1);
    Lambda(1) = 12; Lambda(2) = 6;
    Lambda = diag(Lambda);

    data_cov = Q*Lambda*Q';

    X = mvnrnd(zeros(p,1),data_cov,n);
end




