function v_ret = get_variance_truncated_eigenvector(data, variances, gamma)
     [n,d]       = size(data);
     v           = variances;
     [~,idx]     = sort(-v);
     new_data    = zeros(n,gamma);
     support_set = zeros(gamma,1);
     v_ret       = zeros(d,1);
     count       = 0;
     for itr=1:gamma
         i = idx(itr);
         support_set(itr) = i;
         count = count + 1;
         if(count >= gamma)
             break;
         end
     end
     for t=1:n
        x_t = data(t,:)';
        new_data(t,:) = x_t(support_set);
     end
     truncated_cov_mat = cov(new_data);
     [U,Lambda]        = eig(truncated_cov_mat);
     U                 = real(U);
     Lambda            = real(Lambda);
     [~, ind]          = sort(diag(Lambda)); 
     U                 = U(:, ind);
     v_ret_truncated   = U(:, gamma);
     for itr=1:gamma
         i = support_set(itr);
         v_ret(i) = v_ret_truncated(itr);
     end
end