#!/usr/bin/env python3
# -*- coding: utf-8 -*- 
"""
Created on Tue Aug 18 23:46:07 2020

@author: htp
"""

import bench_func
import numpy as np
from numpy import pi

test_fun = 1

if test_fun == 1:
    f_name = 'ackley1000D'
    fun_m = bench_func.ackley_m
    bound = [-32.5, 32.5]
    dim = 1000                   
    GH_pts = 5
    lr_init = 6.5
    lr_end = 0.065
    lr_decay = 2           
    rr_init = 6.5        
    rr_end = 0.065          
    rr_decay = 2   
    n_iter = 50
    x_opt = np.zeros((1,dim))

elif test_fun == 2:
    f_name = 'Alpine1000D' 
    fun_m = bench_func.alpine_m
    bound = [-10, 10]
    dim = 1000
    GH_pts = 5
    lr_init = 2        
    lr_end = 0.02
    lr_decay = 2           
    rr_init = 2        
    rr_end = 0.02          
    rr_decay = 2      
    n_iter = 150
    x_opt = np.zeros((1,dim))
    
elif test_fun == 3: 
    f_name = 'Ellipsoidal1000D'
    fun_m = bench_func.ellipsoidal_m
    bound = [-2., 2.] 
    dim = 1000
    GH_pts = 5
    lr_init = 0.4        
    lr_end = 0.004
    lr_decay = 2           
    rr_init = 0.4        
    rr_end = 0.004          
    rr_decay = 2     
    n_iter = 300
    x_opt = np.zeros((1,dim))
    
elif test_fun == 4:
    f_name = 'Quintic1000D' 
    fun_m = bench_func.quintic_m
    bound = [-10, 10]
    dim = 1000
    GH_pts = 5
    lr_init = 2        
    lr_end = 0.02
    lr_decay = 2           
    rr_init = 2        
    rr_end = 0.02          
    rr_decay = 2      
    n_iter = 120
    x_opt = -np.ones((1,dim))

  
elif test_fun == 5:
    f_name = 'Rastrigin1000D'
    fun_m = bench_func.rastrigin_m
    bound = [-5.12, 5.12]
    dim = 1000
    GH_pts = 5
    lr_init = 0.5        
    lr_end = 0.001
    lr_decay = 2           
    rr_init = 1        
    rr_end = 0.5          
    rr_decay = 2      
#    n_iter = 20
    n_iter = 50
    x_opt = np.zeros((1,dim))

    
elif test_fun == 6:
    f_name = 'Rosenbrock1000D'
    fun_m = bench_func.rosenbrock_m
    bound = [-5., 10.] 
    dim = 1000
    GH_pts = 5
    lr_init = 1.5        
    lr_end = 0.15
    lr_decay = 2           
    rr_init = 1.5        
    rr_end = 0.15          
    rr_decay = 4      
    n_iter = 60
    x_opt = np.ones((1,dim))


elif test_fun == 7: 
    f_name = 'Schaffer1000D'
    fun_m = bench_func.schaffer_m
    bound = [-100., 100.] 
    dim = 1000
    GH_pts = 5
    lr_init = 5        
    lr_end = 0.001
    lr_decay = 1           
    rr_init = 50        
    rr_end = 0.001          
    rr_decay = 2      
    n_iter = 100
    x_opt = np.zeros((1,dim))
    
    
elif test_fun == 8:
    f_name = 'SharpRidge1000D' 
    fun_m = bench_func.sharp_ridge_m
    bound = [-10, 10]
    dim = 1000
    GH_pts = 5
    lr_init = 2        
    lr_end = 0.02
    lr_decay = 2           
    rr_init = 2        
    rr_end = 0.02          
    rr_decay = 2      
    n_iter = 50
    x_opt = np.zeros((1,dim))
    

elif test_fun == 9:
    f_name = 'Solomon1000D' 
    fun_m = bench_func.solomon_m
    bound = [-100, 100]
    dim = 1000
    GH_pts = 5
    lr_init = 20        
    lr_end = 0.2
    lr_decay = 2           
    rr_init = 20        
    rr_end = 0.2          
    rr_decay = 2      
    n_iter = 60
    x_opt = np.zeros((1,dim))
    
    
elif test_fun == 10:
    f_name = 'Styblinsky1000D' 
    fun_m = bench_func.styblinski_m
    bound = [-5, 5]
    dim = 1000
    GH_pts = 5
    lr_init = 1        
    lr_end = 0.01
    lr_decay = 2           
    rr_init = 1        
    rr_end = 0.01          
    rr_decay = 2      
    n_iter = 60
    x_opt = -2.903534*np.ones((1,dim))    
    
    
elif test_fun == 11:
    f_name = 'Trigonometric1000D' 
    fun_m = bench_func.trigonometric2_m
    bound = [-500, 500]
    dim = 1000
    GH_pts = 5
    lr_init = 100        
    lr_end = 1
    lr_decay = 2           
    rr_init = 100        
    rr_end = 1          
    rr_decay = 2      
    n_iter = 50
    x_opt = 0.9*np.ones((1,dim))
    
    
elif test_fun == 12:
    f_name = 'Wavy1000D' 
    fun_m = bench_func.wavy_m
    bound = [-pi, pi]
    dim = 1000
    GH_pts = 5
    lr_init = pi/5        
    lr_end = pi/500
    lr_decay = 2           
    rr_init = pi/5        
    rr_end = pi/500          
    rr_decay = 2      
    n_iter = 60
    x_opt = np.zeros((1,dim))

