/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.junit.writer.TestSuiteWriterUtils;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.MasterNodeRemote;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.classhandling.JDKClassResetter;
import org.evosuite.runtime.instrumentation.MethodCallReplacementCache;
import org.evosuite.runtime.mock.MockFramework;
import org.evosuite.runtime.sandbox.MSecurityManager;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.SpawnProcessKeepAliveChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProcess {
    private static final Logger logger = LoggerFactory.getLogger(ClientProcess.class);
    public static final String CLIENT_PREFIX = "Client-";
    public static final String DEFAULT_CLIENT_NAME = "Client-0";
    private static String identifier;
    public static TestGenerationResult result;

    public void run() {
        Properties.getInstance();
        ClientProcess.setupRuntimeProperties();
        JDKClassResetter.init();
        Sandbox.setCheckForInitialization(Properties.SANDBOX);
        MockFramework.enable();
        if (TestSuiteWriterUtils.needToUseAgent() && (Properties.JUNIT_CHECK == Properties.JUnitCheckValues.TRUE || Properties.JUNIT_CHECK == Properties.JUnitCheckValues.OPTIONAL)) {
            this.initializeToolJar();
        }
        MSecurityManager.setupMasterNodeRemoteHandling(MasterNodeRemote.class);
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Connecting to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        boolean registered = ClientServices.getInstance().registerServices(ClientProcess.getIdentifier());
        if (!registered) {
            result = TestGenerationResultBuilder.buildErrorResult("Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
            throw new RuntimeException(ClientProcess.getPrettyPrintIdentifier() + "Could not connect to master process on port " + Properties.PROCESS_COMMUNICATION_PORT);
        }
        if (Properties.SPAWN_PROCESS_MANAGER_PORT != null) {
            SpawnProcessKeepAliveChecker.getInstance().registerToRemoteServerAndDieIfFails(Properties.SPAWN_PROCESS_MANAGER_PORT);
        }
        ClientServices.getInstance().getClientNode().waitUntilDone();
        ClientServices.getInstance().stopServices();
        SpawnProcessKeepAliveChecker.getInstance().unRegister();
    }

    private void initializeToolJar() {
        ClassPathHacker.initializeToolJar();
    }

    private static void setupRuntimeProperties() {
        RuntimeSettings.useVFS = Properties.VIRTUAL_FS;
        RuntimeSettings.mockJVMNonDeterminism = Properties.REPLACE_CALLS;
        RuntimeSettings.mockSystemIn = Properties.REPLACE_SYSTEM_IN;
        RuntimeSettings.mockGUI = Properties.REPLACE_GUI;
        RuntimeSettings.sandboxMode = Properties.SANDBOX_MODE;
        RuntimeSettings.maxNumberOfThreads = Properties.MAX_STARTED_THREADS;
        RuntimeSettings.maxNumberOfIterationsPerLoop = Properties.MAX_LOOP_ITERATIONS;
        RuntimeSettings.useVNET = Properties.VIRTUAL_NET;
        RuntimeSettings.useSeparateClassLoader = Properties.USE_SEPARATE_CLASSLOADER;
        RuntimeSettings.className = Properties.TARGET_CLASS;
        RuntimeSettings.applyUIDTransformation = true;
        RuntimeSettings.isRunningASystemTest = Properties.IS_RUNNING_A_SYSTEM_TEST;
        MethodCallReplacementCache.resetSingleton();
    }

    public static String getIdentifier() {
        return identifier;
    }

    public static String getPrettyPrintIdentifier() {
        if (Properties.NUM_PARALLEL_CLIENTS == 1) {
            return "";
        }
        return identifier + ": ";
    }

    public static void main(String[] args) {
        block5: {
            boolean onThread = Properties.CLIENT_ON_THREAD;
            identifier = args.length > 0 ? args[0] : DEFAULT_CLIENT_NAME;
            try {
                LoggingUtils.getEvoLogger().info("* Starting " + ClientProcess.getIdentifier());
                ClientProcess process = new ClientProcess();
                TimeController.resetSingleton();
                process.run();
                if (!onThread) {
                    System.exit(0);
                }
            }
            catch (Throwable t) {
                logger.error(ClientProcess.getPrettyPrintIdentifier() + "Error when generating tests for: " + Properties.TARGET_CLASS + " with seed " + Randomness.getSeed() + ". Configuration id : " + Properties.CONFIGURATION_ID, t);
                t.printStackTrace();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (onThread) break block5;
                System.exit(1);
            }
        }
    }
}

