/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.Serializable;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;

public class ProgressMonitor<T extends Chromosome<T>>
implements SearchListener<T>,
Serializable {
    private static final long serialVersionUID = -8518559681906649686L;
    private StoppingCondition<T> stoppingCondition;
    private long max;
    private int currentCoverage;
    protected int lastCoverage;
    protected int lastProgress;
    protected int iteration;
    protected ClientState state;

    public ProgressMonitor() {
        this.stoppingCondition = null;
        this.max = 1L;
        this.currentCoverage = 0;
        this.lastCoverage = 0;
        this.lastProgress = 0;
        this.iteration = 0;
        this.state = ClientState.INITIALIZATION;
    }

    public ProgressMonitor(ProgressMonitor<T> that) {
        this.stoppingCondition = (StoppingCondition)that.stoppingCondition.clone();
        this.max = that.max;
        this.currentCoverage = that.currentCoverage;
        this.lastCoverage = that.lastCoverage;
        this.lastProgress = that.lastProgress;
        this.iteration = that.iteration;
        this.state = that.state;
    }

    public void updateStatus(int percent) {
        ClientState state = ClientState.SEARCH;
        ClientStateInformation information = new ClientStateInformation(state);
        information.setCoverage(this.currentCoverage);
        information.setProgress(percent);
        information.setIteration(this.iteration);
        ClientServices.getInstance().getClientNode().changeState(state, information);
        this.lastProgress = percent;
        this.lastCoverage = this.currentCoverage;
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
        for (StoppingCondition<T> cond : algorithm.getStoppingConditions()) {
            if (cond.getLimit() == 0L) continue;
            this.stoppingCondition = cond;
            this.max = this.stoppingCondition.getLimit();
            break;
        }
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        long current = this.stoppingCondition.getCurrentValue();
        this.currentCoverage = (int)Math.floor(((Chromosome)algorithm.getBestIndividual()).getCoverage() * 100.0);
        this.updateStatus((int)(100L * current / this.max));
        ++this.iteration;
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
        this.currentCoverage = (int)Math.floor(((Chromosome)algorithm.getBestIndividual()).getCoverage() * 100.0);
        if (this.currentCoverage > this.lastCoverage) {
            this.updateStatus((int)(100L * this.stoppingCondition.getCurrentValue() / this.max));
        }
    }

    @Override
    public void fitnessEvaluation(T individual) {
        int current = (int)((long)((int)(100L * this.stoppingCondition.getCurrentValue())) / this.max);
        this.currentCoverage = (int)Math.floor(((Chromosome)individual).getCoverage() * 100.0);
        if (this.currentCoverage > this.lastCoverage || current > this.lastProgress) {
            this.updateStatus(current);
        }
    }

    @Override
    public void modification(T individual) {
    }
}

