/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;

public class ArrayEqualsAssertion
extends Assertion {
    private static final long serialVersionUID = -1868479914750970330L;

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        ArrayEqualsAssertion s = new ArrayEqualsAssertion();
        s.source = this.source.copy(newTestCase, offset);
        s.value = this.value;
        s.comment = this.comment;
        return s;
    }

    @Override
    public String getCode() {
        return "assertArrayEquals(" + this.value + ", " + this.source.getName() + ");";
    }

    private Object[] getArray(Object val) {
        int arrlength = Array.getLength(val);
        Object[] outputArray = new Object[arrlength];
        for (int i = 0; i < arrlength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (this.source.getObject(scope) == null) {
                return this.value == null;
            }
            return Arrays.equals(this.getArray(this.source.getObject(scope)), (Object[])this.value);
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Assertion other = (Assertion)obj;
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !Arrays.equals((Object[])this.value, (Object[])other.value));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.value == null ? 0 : Arrays.hashCode((Object[])this.value));
        return result;
    }
}

