/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.Set;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertionTraceObserver<T extends OutputTraceEntry>
extends ExecutionObserver {
    protected static final Logger logger = LoggerFactory.getLogger(AssertionTraceObserver.class);
    protected OutputTrace<T> trace = new OutputTrace();

    protected boolean checkThread() {
        return ExecutionTracer.isThreadNeqCurrentThread();
    }

    @Override
    public synchronized void output(int position, String output) {
    }

    protected void visitDependencies(Statement statement, Scope scope) {
        Set<VariableReference> dependencies = currentTest.getDependencies(statement.getReturnValue());
        for (VariableReference var : dependencies) {
            if (var.isVoid() || statement.getTestCase().getStatement(var.getStPosition()) instanceof FunctionalMockStatement || var.isVoid()) continue;
            try {
                this.visit(statement, scope, var);
            }
            catch (CodeUnderTestException codeUnderTestException) {}
        }
    }

    protected void visitReturnValue(Statement statement, Scope scope) {
        if (statement.getReturnClass().equals(Void.TYPE)) {
            return;
        }
        if (statement.isAssignmentStatement()) {
            return;
        }
        try {
            this.visit(statement, scope, statement.getReturnValue());
        }
        catch (CodeUnderTestException codeUnderTestException) {
            // empty catch block
        }
    }

    protected abstract void visit(Statement var1, Scope var2, VariableReference var3) throws CodeUnderTestException;

    @Override
    public synchronized void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (statement instanceof FunctionalMockStatement) {
            return;
        }
        if (statement instanceof PrimitiveStatement) {
            return;
        }
        if (exception != null) {
            return;
        }
        if (statement instanceof FieldStatement) {
            this.visitReturnValue(statement, scope);
        } else {
            this.visitDependencies(statement, scope);
        }
    }

    @Override
    public synchronized void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public synchronized void clear() {
        this.trace.clear();
    }

    public synchronized OutputTrace<T> getTrace() {
        return this.trace.clone();
    }
}

