/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.evosuite.instrumentation.BytecodeInstrumentation;
import org.evosuite.runtime.Random;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.InheritanceTree;
import org.evosuite.setup.TestCluster;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.utils.JdkPureMethodsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheapPurityAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(CheapPurityAnalyzer.class);
    private final HashSet<MethodEntry> updateFieldMethodList = new HashSet();
    private final HashMap<MethodEntry, Boolean> purityCache = new HashMap();
    private final HashSet<MethodEntry> methodEntries = new HashSet();
    private static final boolean DEFAULT_PURITY_VALUE = false;
    private static final CheapPurityAnalyzer instance = new CheapPurityAnalyzer();
    private final HashMap<MethodEntry, Set<MethodEntry>> staticCalls = new HashMap();
    private final HashMap<MethodEntry, Set<MethodEntry>> virtualCalls = new HashMap();
    private final HashMap<MethodEntry, Set<MethodEntry>> specialCalls = new HashMap();
    private final HashMap<MethodEntry, Set<MethodEntry>> interfaceCalls = new HashMap();
    private final HashSet<MethodEntry> interfaceMethodEntries = new HashSet();
    private final HashSet<MethodEntry> methodsWithBodies = new HashSet();

    public static CheapPurityAnalyzer getInstance() {
        return instance;
    }

    public List<String> getPureMethods(String className) {
        ArrayList<String> list = new ArrayList<String>();
        for (MethodEntry m : this.methodEntries) {
            if (!m.className.equals(className) || !this.isPure(m) || m.methodName.equals("__STATIC_RESET")) continue;
            list.add(m.methodName + m.descriptor);
        }
        return list;
    }

    public boolean isPure(String className, String methodName, String descriptor) {
        MethodEntry entry = new MethodEntry(className, methodName, descriptor);
        return this.isPure(entry);
    }

    private boolean isPure(MethodEntry entry) {
        Stack<MethodEntry> emptyStack = new Stack<MethodEntry>();
        return this.isPure(entry, emptyStack);
    }

    private boolean isCached(MethodEntry entry) {
        return this.purityCache.containsKey(entry);
    }

    private boolean getCacheValue(MethodEntry entry) {
        return this.purityCache.get(entry);
    }

    private void addCacheValue(MethodEntry entry, boolean new_value) {
        boolean old_value;
        if (this.isCached(entry) && !(old_value = this.purityCache.get(entry).booleanValue()) && new_value) {
            String fullyQuantifiedMethodName = entry.className + "." + entry.methodName + entry.descriptor;
            logger.warn("Purity value in cache cannot evolve from NOT_PURE to PURE for method " + fullyQuantifiedMethodName);
        }
        this.purityCache.put(entry, new_value);
    }

    private boolean isPure0(MethodEntry entry, Stack<MethodEntry> callStack) {
        Set<MethodEntry> calls;
        if (this.isRandomCall(entry)) {
            return false;
        }
        if (this.isArrayCall(entry)) {
            return true;
        }
        if (this.isJdkPureMethod(entry)) {
            return true;
        }
        if (!BytecodeInstrumentation.checkIfCanInstrument(entry.className)) {
            return false;
        }
        if (this.updateFieldMethodList.contains(entry)) {
            return false;
        }
        if (this.staticCalls.containsKey(entry) && this.checkAnyCallImpure(calls = this.staticCalls.get(entry), entry, callStack)) {
            return false;
        }
        if (this.specialCalls.containsKey(entry) && this.checkAnyCallImpure(calls = this.specialCalls.get(entry), entry, callStack)) {
            return false;
        }
        if (this.virtualCalls.containsKey(entry) && this.checkAnyCallImpure(calls = this.virtualCalls.get(entry), entry, callStack)) {
            return false;
        }
        if (this.interfaceCalls.containsKey(entry) && this.checkAnyCallImpure(calls = this.interfaceCalls.get(entry), entry, callStack)) {
            return false;
        }
        if (this.checkAnyOverridingMethodImpure(entry, callStack)) {
            return false;
        }
        if (this.interfaceMethodEntries.contains(entry)) {
            return true;
        }
        if (this.methodsWithBodies.contains(entry)) {
            return true;
        }
        boolean purityValueClosestSuperclass = this.isPureSuperclass(entry, callStack);
        return purityValueClosestSuperclass;
    }

    private boolean isPureSuperclass(MethodEntry entry, Stack<MethodEntry> callStack) {
        InheritanceTree inheritanceTree = TestCluster.getInheritanceTree();
        for (String superClassName : inheritanceTree.getOrderedSuperclasses(entry.className)) {
            MethodEntry superEntry;
            if (superClassName.equals(entry.className) || callStack.contains(superEntry = new MethodEntry(superClassName, entry.methodName, entry.descriptor)) || !this.methodsWithBodies.contains(superEntry)) continue;
            Stack<MethodEntry> newStack = new Stack<MethodEntry>();
            newStack.addAll(callStack);
            newStack.add(superEntry);
            boolean purityValueForSuperClass = this.isPure(superEntry, newStack);
            return purityValueForSuperClass;
        }
        return false;
    }

    private boolean isRandomCall(MethodEntry entry) {
        if (entry.className.equals("java.util.Random")) {
            return true;
        }
        if (entry.className.equals("java.security.SecureRandom")) {
            return true;
        }
        if (entry.className.equals(Random.class.getName())) {
            return true;
        }
        return entry.className.equals("java.lang.Math") && entry.methodName.equals("random");
    }

    private boolean isArrayCall(MethodEntry entry) {
        return entry.className.startsWith("[");
    }

    private boolean isPure(MethodEntry entry, Stack<MethodEntry> callStack) {
        if (this.isCached(entry)) {
            return this.getCacheValue(entry);
        }
        boolean isPure = this.isPure0(entry, callStack);
        this.addCacheValue(entry, isPure);
        return isPure;
    }

    private boolean checkAnyOverridingMethodImpure(MethodEntry entry, Stack<MethodEntry> callStack) {
        String className;
        InheritanceTree inheritanceTree = DependencyAnalysis.getInheritanceTree();
        if (!inheritanceTree.hasClass(className = "" + entry.className)) {
            logger.warn(className + " was not found in the inheritance tree. Using DEFAULT value for cheap-purity analysis");
            return false;
        }
        Set<String> subclasses = inheritanceTree.getSubclasses(className);
        for (String subclassName : subclasses) {
            MethodEntry subclassEntry;
            if (entry.className.equals(subclassName) || callStack.contains(subclassEntry = new MethodEntry(subclassName, entry.methodName, entry.descriptor)) || !this.methodEntries.contains(subclassEntry)) continue;
            Stack<MethodEntry> newStack = new Stack<MethodEntry>();
            newStack.addAll(callStack);
            newStack.add(subclassEntry);
            if (this.isPure(subclassEntry, newStack)) continue;
            return true;
        }
        return false;
    }

    private boolean isJdkPureMethod(MethodEntry entry) {
        String paraz = entry.descriptor;
        Type[] parameters = Type.getArgumentTypes(paraz);
        String newParams = "";
        if (parameters.length != 0) {
            for (Type i : parameters) {
                newParams = newParams + "," + i.getClassName();
            }
            newParams = newParams.substring(1, newParams.length());
        }
        String qualifiedName = entry.className + "." + entry.methodName + "(" + newParams + ")";
        return JdkPureMethodsList.instance.checkPurity(qualifiedName);
    }

    private boolean checkAnyCallImpure(Set<MethodEntry> calls, MethodEntry entry, Stack<MethodEntry> callStack) {
        for (MethodEntry callMethodEntry : calls) {
            if (callStack.contains(callMethodEntry)) continue;
            Stack<MethodEntry> copyOfStack = new Stack<MethodEntry>();
            copyOfStack.addAll(callStack);
            copyOfStack.add(entry);
            if (this.isPure(callMethodEntry, copyOfStack)) continue;
            return true;
        }
        return false;
    }

    public boolean isPure(Method method) {
        String className = method.getDeclaringClass().getName();
        if (MockList.isAMockClass(className)) {
            className = method.getDeclaringClass().getSuperclass().getName();
        }
        String methodName = method.getName();
        String descriptor = Type.getMethodDescriptor(method);
        MethodEntry entry = new MethodEntry(className, methodName, descriptor);
        boolean isPureValue = this.isPure(entry);
        return isPureValue;
    }

    public void addMethod(String className, String methodName, String methodDescriptor) {
        MethodEntry entry = new MethodEntry(className, methodName, methodDescriptor);
        this.methodEntries.add(entry);
    }

    public void addUpdatesFieldMethod(String className, String methodName, String descriptor) {
        String classNameWithDots = className.replace('/', '.');
        MethodEntry entry = new MethodEntry(classNameWithDots, methodName, descriptor);
        this.updateFieldMethodList.add(entry);
    }

    public void addStaticCall(String sourceClassName, String sourceMethodName, String sourceDescriptor, String targetClassName, String targetMethodName, String targetDescriptor) {
        CheapPurityAnalyzer.addCall(this.staticCalls, sourceClassName, sourceMethodName, sourceDescriptor, targetClassName, targetMethodName, targetDescriptor);
    }

    public void addVirtualCall(String sourceClassName, String sourceMethodName, String sourceDescriptor, String targetClassName, String targetMethodName, String targetDescriptor) {
        CheapPurityAnalyzer.addCall(this.virtualCalls, sourceClassName, sourceMethodName, sourceDescriptor, targetClassName, targetMethodName, targetDescriptor);
    }

    public void addInterfaceCall(String sourceClassName, String sourceMethodName, String sourceDescriptor, String targetClassName, String targetMethodName, String targetDescriptor) {
        CheapPurityAnalyzer.addCall(this.interfaceCalls, sourceClassName, sourceMethodName, sourceDescriptor, targetClassName, targetMethodName, targetDescriptor);
    }

    private static void addCall(HashMap<MethodEntry, Set<MethodEntry>> calls, String sourceClassName, String sourceMethodName, String sourceDescriptor, String targetClassName, String targetMethodName, String targetDescriptor) {
        MethodEntry sourceEntry = new MethodEntry(sourceClassName, sourceMethodName, sourceDescriptor);
        MethodEntry targetEntry = new MethodEntry(targetClassName, targetMethodName, targetDescriptor);
        if (!calls.containsKey(sourceEntry)) {
            calls.put(sourceEntry, new HashSet());
        }
        calls.get(sourceEntry).add(targetEntry);
    }

    public void addSpecialCall(String sourceClassName, String sourceMethodName, String sourceDescriptor, String targetClassName, String targetMethodName, String targetDescriptor) {
        CheapPurityAnalyzer.addCall(this.specialCalls, sourceClassName, sourceMethodName, sourceDescriptor, targetClassName, targetMethodName, targetDescriptor);
    }

    public void addInterfaceMethod(String className, String methodName, String methodDescriptor) {
        MethodEntry entry = new MethodEntry(className, methodName, methodDescriptor);
        this.interfaceMethodEntries.add(entry);
    }

    public void addMethodWithBody(String className, String methodName, String methodDescriptor) {
        MethodEntry entry = new MethodEntry(className, methodName, methodDescriptor);
        this.methodsWithBodies.add(entry);
    }

    private static class MethodEntry {
        private final String className;
        private final String methodName;
        private final String descriptor;

        public MethodEntry(String className, String methodName, String descriptor) {
            this.className = className;
            this.methodName = methodName;
            this.descriptor = descriptor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.className.hashCode();
            result = 31 * result + this.descriptor.hashCode();
            result = 31 * result + this.methodName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodEntry other = (MethodEntry)obj;
            return this.className.equals(other.className) && this.methodName.equals(other.methodName) && this.descriptor.equals(other.descriptor);
        }

        public String toString() {
            return "MethodEntry [className=" + this.className + ", methodName=" + this.methodName + ", descriptor=" + String.valueOf(this.descriptor) + "]";
        }
    }
}

