/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.Collection;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.VariableReference;

public class ContainsAssertion
extends Assertion {
    private static final long serialVersionUID = -86374077651820640L;
    protected VariableReference containedVariable;

    public VariableReference getContainedVariable() {
        return this.containedVariable;
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        ContainsAssertion s = new ContainsAssertion();
        s.source = this.source.copy(newTestCase, offset);
        s.value = this.value;
        s.containedVariable = this.containedVariable.copy(newTestCase, offset);
        s.comment = this.comment;
        return s;
    }

    @Override
    public String getCode() {
        return "assertTrue(" + this.source.getName() + ".contains(" + this.containedVariable.getName() + "));";
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (this.source.getObject(scope) == null) {
                return this.value == null;
            }
            Object container = this.source.getObject(scope);
            Object object = this.containedVariable.getObject(scope);
            if (container instanceof Collection) {
                return ((Collection)container).contains(object);
            }
            return false;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Set<VariableReference> getReferencedVariables() {
        Set<VariableReference> vars = super.getReferencedVariables();
        vars.add(this.source);
        vars.add(this.containedVariable);
        return vars;
    }
}

