/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TimeController;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.CompleteAssertionGenerator;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.MutationAssertionGenerator;
import org.evosuite.assertion.NullAssertion;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMutationAssertionGenerator
extends MutationAssertionGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SimpleMutationAssertionGenerator.class);

    @Override
    public void addAssertions(TestSuiteChromosome suite) {
        this.setupClassLoader(suite);
        if (!Properties.hasTargetClassBeenLoaded()) {
            Properties.getTargetClassAndDontInitialise();
            if (!Properties.hasTargetClassBeenLoaded()) {
                logger.warn("Could not initialize SUT before Assertion generation");
            }
        }
        HashSet<Integer> tkilled = new HashSet<Integer>();
        int numTest = 0;
        boolean timeIsShort = false;
        for (TestCase test : suite.getTests()) {
            if (!TimeController.getInstance().isThereStillTimeInThisPhase()) {
                logger.warn("Reached maximum time to generate assertions, aborting assertion generation");
                break;
            }
            if (!timeIsShort && TimeController.getInstance().getPhasePercentage() > Properties.ASSERTION_MINIMIZATION_FALLBACK_TIME && (double)numTest < Properties.ASSERTION_MINIMIZATION_FALLBACK * (double)suite.size()) {
                logger.warn("Assertion minimization is taking too long ({}% of time used, but only {}/{} tests minimized), falling back to using all assertions", TimeController.getInstance().getPhasePercentage(), numTest, suite.size());
                timeIsShort = true;
            }
            if (timeIsShort) {
                CompleteAssertionGenerator generator = new CompleteAssertionGenerator();
                generator.addAssertions(test);
                ++numTest;
                continue;
            }
            this.addAssertions(test, tkilled);
            ClientState state = ClientState.ASSERTION_GENERATION;
            ClientStateInformation information = new ClientStateInformation(state);
            information.setProgress(100 * numTest++ / suite.size());
            ClientServices.getInstance().getClientNode().changeState(state, information);
        }
        this.calculateMutationScore(tkilled);
        this.restoreCriterion(suite);
    }

    private void addAssertions(TestCase test, Set<Integer> killed) {
        this.addAssertions(test, killed, this.mutants);
        this.filterRedundantNonnullAssertions(test);
    }

    /*
     * WARNING - void declaration
     */
    private void addAssertions(TestCase test, Set<Integer> killed, Map<Integer, Mutation> mutants) {
        if (test.isEmpty()) {
            return;
        }
        logger.debug("Generating assertions");
        int s1 = killed.size();
        logger.debug("Running on original");
        ExecutionResult origResult = this.runTest(test);
        if (origResult.hasTimeout() || origResult.hasTestException()) {
            logger.debug("Skipping test, as it has timeouts or exceptions");
            return;
        }
        HashMap mutationTraces = new HashMap();
        ArrayList<Mutation> executedMutants = new ArrayList<Mutation>();
        for (Integer n : origResult.getTrace().getTouchedMutants()) {
            if (!mutants.containsKey(n)) continue;
            executedMutants.add(mutants.get(n));
        }
        Randomness.shuffle(executedMutants);
        logger.debug("Executed mutants: " + origResult.getTrace().getTouchedMutants());
        int numExecutedMutants = 0;
        for (Mutation m : executedMutants) {
            ++numExecutedMutants;
            if (!TimeController.getInstance().isThereStillTimeInThisPhase()) {
                logger.info("Reached maximum time to generate assertions!");
                break;
            }
            assert (m != null);
            if (MutationTimeoutStoppingCondition.isDisabled(m)) {
                killed.add(m.getId());
                continue;
            }
            if (timedOutMutations.containsKey(m) && (Integer)timedOutMutations.get(m) >= Properties.MUTATION_TIMEOUTS) {
                logger.debug("Skipping timed out mutant");
                killed.add(m.getId());
                continue;
            }
            if (exceptionMutations.containsKey(m) && (Integer)exceptionMutations.get(m) >= Properties.MUTATION_TIMEOUTS) {
                logger.debug("Skipping mutant with exceptions");
                killed.add(m.getId());
                continue;
            }
            if (Properties.MAX_MUTANTS_PER_TEST > 0 && numExecutedMutants > Properties.MAX_MUTANTS_PER_TEST) break;
            logger.debug("Running test on mutation {}", (Object)m.getMutationName());
            ExecutionResult mutantResult = this.runTest(test, m);
            int numKilled = 0;
            for (Class clazz : observerClasses) {
                if (mutantResult.getTrace(clazz) == null || origResult.getTrace(clazz) == null) continue;
                numKilled += origResult.getTrace(clazz).getAssertions(test, mutantResult.getTrace(clazz));
            }
            ArrayList traces = new ArrayList(mutantResult.getTraces());
            mutationTraces.put(m, traces);
            if (mutantResult.hasTimeout()) {
                logger.debug("Increasing timeout count!");
                if (!timedOutMutations.containsKey(m)) {
                    timedOutMutations.put(m, 1);
                } else {
                    timedOutMutations.put(m, (Integer)timedOutMutations.get(m) + 1);
                }
                MutationTimeoutStoppingCondition.timeOut(m);
            } else if (!mutantResult.noThrownExceptions() && origResult.noThrownExceptions()) {
                logger.debug("Increasing exception count.");
                if (!exceptionMutations.containsKey(m)) {
                    exceptionMutations.put(m, 1);
                } else {
                    exceptionMutations.put(m, (Integer)exceptionMutations.get(m) + 1);
                }
                MutationTimeoutStoppingCondition.raisedException(m);
            }
            if (numKilled <= 0 && !mutantResult.hasTimeout() && (mutantResult.noThrownExceptions() || !origResult.noThrownExceptions())) continue;
            killed.add(m.getId());
        }
        List<Assertion> list = test.getAssertions();
        logger.info("Got " + list.size() + " assertions");
        HashMap<Integer, Set<Integer>> killMap = new HashMap<Integer, Set<Integer>>();
        int num = 0;
        for (Assertion assertion : list) {
            HashSet<Integer> killedMutations = new HashSet<Integer>();
            for (Mutation mutation : executedMutants) {
                boolean isKilled = false;
                if (mutationTraces.containsKey(mutation)) {
                    for (OutputTrace trace : (List)mutationTraces.get(mutation)) {
                        if (!trace.isDetectedBy(assertion)) continue;
                        isKilled = true;
                        break;
                    }
                }
                if (!isKilled) continue;
                killedMutations.add(mutation.getId());
                assertion.addKilledMutation(mutation);
            }
            killMap.put(num, killedMutations);
            ++num;
        }
        int killedBefore = this.getNumKilledMutants(test, mutationTraces, executedMutants);
        logger.debug("Need to kill mutants: " + killedBefore);
        logger.debug(((Object)killMap).toString());
        this.minimize(test, executedMutants, list, killMap);
        int killedAfter = this.getNumKilledMutants(test, mutationTraces, executedMutants);
        int s2 = killed.size() - s1;
        assert (killedBefore == killedAfter) : "Mutants killed before / after / should be: " + killedBefore + "/" + killedAfter + "/" + s2 + ": " + test.toCode();
        logger.info("Mutants killed before / after / should be: " + killedBefore + "/" + killedAfter + "/" + s2);
        logger.info("Assertions in this test: " + test.getAssertions().size());
        if (this.primitiveWithoutAssertion(test.getStatement(test.size() - 1))) {
            logger.info("Last statement has primitive return value but no assertions: " + test.toCode());
            for (Assertion assertion : list) {
                if (!(assertion instanceof PrimitiveAssertion) || !assertion.getStatement().equals(test.getStatement(test.size() - 1))) continue;
                logger.debug("Adding a primitive assertion " + assertion);
                test.getStatement(test.size() - 1).addAssertion(assertion);
                break;
            }
            this.filterInspectorPrimitiveDuplication(test.getStatement(test.size() - 1));
        }
        if (test.getStatement(test.size() - 1).getAssertions().isEmpty() || this.justNullAssertion(test.getStatement(test.size() - 1))) {
            logger.info("Last statement has no assertions: " + test.toCode());
            logger.info("Assertions to choose from: " + list.size());
            if (test.getStatement(test.size() - 1).getAssertions().isEmpty()) {
                logger.debug("Last statement: " + test.getStatement(test.size() - 1).getCode());
            }
            if (origResult.isThereAnExceptionAtPosition(test.size() - 1)) {
                logger.debug("Exception on last statement!");
            }
            if (this.justNullAssertion(test.getStatement(test.size() - 1))) {
                logger.debug("Just null assertions on last statement: " + test.toCode());
            }
            boolean haveAssertion = false;
            for (Assertion assertion : list) {
                if (!(assertion instanceof PrimitiveAssertion) || !assertion.getStatement().equals(test.getStatement(test.size() - 1))) continue;
                logger.debug("Adding a primitive assertion " + assertion);
                test.getStatement(test.size() - 1).addAssertion(assertion);
                haveAssertion = true;
                break;
            }
            if (!haveAssertion) {
                logger.info("Could not find a primitive assertion, continuing search");
                for (Assertion assertion : list) {
                    if (assertion instanceof NullAssertion || !assertion.getStatement().equals(test.getStatement(test.size() - 1))) continue;
                    logger.info("Adding an assertion: " + assertion);
                    test.getStatement(test.size() - 1).addAssertion(assertion);
                    haveAssertion = true;
                    break;
                }
            }
            if (!haveAssertion) {
                MethodStatement methodStatement;
                Method method;
                logger.info("After second round we still have no assertion");
                Object var16_37 = null;
                if (test.getStatement(test.size() - 1) instanceof MethodStatement && (method = (methodStatement = (MethodStatement)test.getStatement(test.size() - 1)).getMethod().getMethod()).getParameterTypes().length == 0 && method.getReturnType().isPrimitive() && !method.getReturnType().equals(Void.TYPE)) {
                    Method method2 = method;
                }
                for (OutputTrace<?> trace : origResult.getTraces()) {
                    trace.getAllAssertions(test);
                }
                HashSet<Assertion> target = new HashSet<Assertion>(test.getStatement(test.size() - 1).getAssertions());
                logger.debug("Found assertions: " + target.size());
                test.removeAssertions();
                VariableReference targetVar = test.getStatement(test.size() - 1).getReturnValue();
                if (!targetVar.isVoid()) {
                    logger.debug("Return value is non void: " + targetVar.getClassName());
                    int maxAssertions = 1;
                    int numAssertions = 0;
                    for (Assertion ass : target) {
                        if (ass.getReferencedVariables().contains(targetVar) && !(ass instanceof NullAssertion)) {
                            void var16_39;
                            if (ass instanceof InspectorAssertion && ((InspectorAssertion)ass).inspector.getMethod().equals(var16_39)) continue;
                            test.getStatement(test.size() - 1).addAssertion(ass);
                            logger.debug("Adding assertion " + ass.getCode());
                            if (++numAssertions < maxAssertions) continue;
                            break;
                        }
                        logger.debug("Assertion does not contain target: " + ass.getCode());
                    }
                    if (numAssertions == 0) {
                        for (Assertion ass : target) {
                            if (ass.getReferencedVariables().contains(targetVar)) {
                                test.getStatement(test.size() - 1).addAssertion(ass);
                                logger.debug("Adding assertion " + ass.getCode());
                                if (++numAssertions < maxAssertions) continue;
                                break;
                            }
                            logger.debug("Assertion does not contain target: " + ass.getCode());
                        }
                    }
                } else {
                    logger.debug("Return value is void");
                    Set<VariableReference> targetVars = test.getStatement(test.size() - 1).getVariableReferences();
                    int maxAssertions = 1;
                    int numAssertions = 0;
                    for (Assertion ass : target) {
                        Set<VariableReference> vars = ass.getReferencedVariables();
                        vars.retainAll(targetVars);
                        if (vars.isEmpty()) continue;
                        test.getStatement(test.size() - 1).addAssertion(ass);
                        if (++numAssertions < maxAssertions) continue;
                        break;
                    }
                }
                logger.info("1. Done with assertions");
            }
            logger.info("2. Done with assertions");
            this.filterInspectorPrimitiveDuplication(test.getStatement(test.size() - 1));
        }
        if (!origResult.noThrownExceptions() && !test.getStatement(test.size() - 1).getAssertions().isEmpty()) {
            logger.debug("Removing assertions after exception");
            test.getStatement(test.size() - 1).removeAssertions();
        }
    }

    private void minimize(TestCase test, List<Mutation> mutants, final List<Assertion> assertions, Map<Integer, Set<Integer>> killMap) {
        HashSet to_kill = new HashSet();
        for (Map.Entry<Integer, Set<Integer>> entry : killMap.entrySet()) {
            to_kill.addAll(entry.getValue());
        }
        logger.debug("Need to kill mutants: " + to_kill.size());
        HashSet<Integer> killed = new HashSet<Integer>();
        HashSet<Assertion> result = new HashSet<Assertion>();
        boolean done = false;
        while (!done) {
            class Pair
            implements Comparable<Object> {
                Integer assertion;
                Integer num_killed;

                public Pair(int a, int k) {
                    this.assertion = a;
                    this.num_killed = k;
                }

                @Override
                public int compareTo(Object o) {
                    Pair other = (Pair)o;
                    if (this.num_killed.equals(other.num_killed)) {
                        Assertion first = (Assertion)assertions.get(this.assertion);
                        Assertion second = (Assertion)assertions.get(other.assertion);
                        if (first instanceof PrimitiveAssertion) {
                            return 1;
                        }
                        if (second instanceof PrimitiveAssertion) {
                            return -1;
                        }
                        return this.assertion.compareTo(other.assertion);
                    }
                    return this.num_killed.compareTo(other.num_killed);
                }
            }
            ArrayList<Pair> a = new ArrayList<Pair>();
            for (Map.Entry<Integer, Set<Integer>> entry : killMap.entrySet()) {
                int num = 0;
                for (Integer m : entry.getValue()) {
                    if (killed.contains(m)) continue;
                    ++num;
                }
                if (num <= 0) continue;
                a.add(new Pair(entry.getKey(), num));
            }
            if (a.isEmpty()) {
                done = true;
                continue;
            }
            Pair best = (Pair)Collections.max(a);
            result.add(assertions.get(best.assertion));
            for (Integer m : killMap.get(best.assertion)) {
                killed.add(m);
                to_kill.remove(m);
            }
        }
        logger.debug("Killed mutants: " + killed.size());
        logger.debug("Minimized assertions from " + assertions.size() + " to " + result.size());
        if (!result.isEmpty()) {
            test.removeAssertions();
            for (Assertion assertion : result) {
                assertion.getStatement().addAssertion(assertion);
            }
        } else {
            logger.debug("Not removing assertions because no new assertions were found");
        }
    }
}

