/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job.schedule;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.job.schedule.OneTimeSchedule;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.utils.LoggingUtils;

public class HistorySchedule
extends OneTimeSchedule {
    private static double MODIFIED = 2.0;
    private static double NOT_MODIFIED = 1.0;
    public static final int COMMIT_IMPROVEMENT = 3;

    public HistorySchedule(JobScheduler scheduler) {
        super(scheduler);
    }

    @Override
    protected List<JobDefinition> createScheduleOnce() {
        ProjectStaticData data = this.scheduler.getProjectData();
        int maximumBudgetPerCore = 60 * this.scheduler.getConfiguration().timeInMinutes;
        int totalBudget = maximumBudgetPerCore * this.scheduler.getConfiguration().getNumberOfUsableCores();
        int minTime = 60 * this.scheduler.getConfiguration().minMinutesPerJob * data.getTotalNumberOfTestableCUTs();
        int extraTime = totalBudget - minTime;
        int number_of_branches = data.getTotalNumberOfBranches();
        double timePerBranch = (double)number_of_branches == 0.0 ? 0.0 : (double)extraTime / (double)number_of_branches;
        ArrayList<ProjectStaticData.ClassInfo> classesInfo = new ArrayList<ProjectStaticData.ClassInfo>(data.getClassInfos());
        classesInfo.sort((a, b) -> {
            if (a.hasChanged() && !b.hasChanged()) {
                return -1;
            }
            if (!a.hasChanged() && b.hasChanged()) {
                return 1;
            }
            return Integer.compare(b.numberOfBranches, a.numberOfBranches);
        });
        int totalLeftOver = 0;
        int totalBudgetUsed = 0;
        LinkedList<JobDefinition> jobs = new LinkedList<JobDefinition>();
        for (ProjectStaticData.ClassInfo c_info : classesInfo) {
            if (!c_info.isTestable()) continue;
            if (!c_info.hasChanged() && !c_info.isToTest()) {
                LoggingUtils.getEvoLogger().info("- Skipping class " + c_info.getClassName() + " because it does not seem to be worth it");
                continue;
            }
            double budget = 60.0 * (double)this.scheduler.getConfiguration().minMinutesPerJob + (double)c_info.numberOfBranches * timePerBranch;
            if ((budget *= c_info.hasChanged() ? MODIFIED : NOT_MODIFIED) > (double)maximumBudgetPerCore) {
                totalLeftOver = (int)((double)totalLeftOver + (budget - (double)maximumBudgetPerCore));
                budget = maximumBudgetPerCore;
            }
            if ((double)totalBudgetUsed + budget <= (double)totalBudget) {
                totalBudgetUsed = (int)((double)totalBudgetUsed + budget);
                LoggingUtils.getEvoLogger().info("+ Going to generate test cases for " + c_info.getClassName() + " using a time budget of " + budget + " seconds. Status of it [" + (c_info.hasChanged() ? "modified" : "not modified") + "]");
                jobs.add(new JobDefinition((int)budget, this.scheduler.getConfiguration().getConstantMemoryPerJob(), c_info.getClassName(), 0, null, null));
                continue;
            }
            LoggingUtils.getEvoLogger().info("- There is not enough time budget to test " + c_info.getClassName() + ". Status of it [" + (c_info.hasChanged() ? "modified" : "not modified") + "]");
            c_info.isToTest(false);
        }
        if ((totalLeftOver += totalBudget - totalBudgetUsed) > 0 && totalLeftOver < totalBudget) {
            LoggingUtils.getEvoLogger().info("Distributing left budget (" + totalLeftOver + ")");
            this.distributeExtraBudgetEvenly(jobs, totalLeftOver, maximumBudgetPerCore);
        }
        return jobs;
    }
}

