/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.project;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.junit.CoverageAnalysis;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectAnalyzer {
    private static final Logger logger = LoggerFactory.getLogger(ProjectAnalyzer.class);
    private final String target;
    private final String prefix;
    private transient Set<String> cutsToAnalyze;
    private boolean validateCutsToAnalyze;

    public ProjectAnalyzer(String target, String prefix, String[] cuts) {
        this.target = target;
        this.prefix = prefix == null ? "" : prefix;
        this.validateCutsToAnalyze = true;
        if (cuts == null) {
            this.cutsToAnalyze = null;
        } else {
            this.cutsToAnalyze = new LinkedHashSet<String>();
            for (String s : cuts) {
                if (s == null || s.isEmpty()) continue;
                this.cutsToAnalyze.add(s.trim());
            }
        }
    }

    public ProjectAnalyzer(String[] cuts) throws NullPointerException {
        if (cuts == null) {
            throw new NullPointerException("Input array cannot be null");
        }
        this.target = null;
        this.prefix = null;
        this.validateCutsToAnalyze = false;
        this.cutsToAnalyze = new LinkedHashSet<String>();
        this.cutsToAnalyze.addAll(Arrays.asList(cuts));
    }

    /*
     * WARNING - void declaration
     */
    private Collection<String> getCutsToAnalyze() {
        if (this.cutsToAnalyze != null && !this.validateCutsToAnalyze) {
            return this.cutsToAnalyze;
        }
        Set<Object> suts = null;
        if (this.target != null) {
            if (!this.target.contains(File.pathSeparator)) {
                suts = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(this.target, this.prefix, false);
            } else {
                void var4_6;
                suts = new LinkedHashSet();
                String[] stringArray = this.target.split(File.pathSeparator);
                int n = stringArray.length;
                boolean bl = false;
                while (var4_6 < n) {
                    String element = stringArray[var4_6];
                    suts.addAll(ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(element, this.prefix, false));
                    ++var4_6;
                }
            }
        } else {
            suts = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(ClassPathHandler.getInstance().getTargetProjectClasspath(), this.prefix, false);
        }
        LinkedList<String> cuts = new LinkedList<String>();
        for (String string : suts) {
            if (this.cutsToAnalyze != null && !this.cutsToAnalyze.contains(string)) continue;
            try {
                Class<?> clazz = Class.forName(string);
                if (CoverageAnalysis.isTest(clazz)) continue;
                cuts.add(string);
            }
            catch (ClassNotFoundException e) {
                logger.error("" + e, e);
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError | UnsatisfiedLinkError e) {
                logger.warn("Cannot initialize class: " + string);
            }
        }
        return cuts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectStaticData analyze() {
        ProjectStaticData data = new ProjectStaticData();
        if (Properties.CTG_SCHEDULE.equals((Object)Properties.AvailableSchedule.HISTORY)) {
            data.initializeLocalHistory();
        }
        for (String className : this.getCutsToAnalyze()) {
            Class<?> theClass = null;
            int numberOfBranches = -1;
            boolean hasCode = false;
            Properties.TARGET_CLASS = className;
            InstrumentingClassLoader instrumenting = new InstrumentingClassLoader();
            BranchPool.getInstance(instrumenting).reset();
            try {
                Sandbox.goingToExecuteUnsafeCodeOnSameThread();
                instrumenting.loadClass(className);
                numberOfBranches = BranchPool.getInstance(instrumenting).getBranchCounter();
                hasCode = numberOfBranches > 0 || BranchPool.getInstance(instrumenting).getBranchlessMethods().size() > 0;
                theClass = ClassLoader.getSystemClassLoader().loadClass(className);
            }
            catch (Exception e) {
                logger.warn("Cannot handle " + className + " due to: " + e.getClass() + " " + e.getMessage());
                continue;
            }
            finally {
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                BranchPool.getInstance(instrumenting).reset();
                Properties.TARGET_CLASS = "";
                continue;
            }
            ProjectStaticData.ClassInfo ci = new ProjectStaticData.ClassInfo(theClass, numberOfBranches, hasCode);
            data.addNewClass(ci);
            if (Properties.CTG_SCHEDULE != Properties.AvailableSchedule.HISTORY) continue;
            ci.setChanged(data.hasChanged(theClass.getCanonicalName() + ".java"));
            ci.isToTest(data.isToTest(theClass.getCanonicalName(), 3));
        }
        return data;
    }
}

