/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Objects;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.dataflow.DefUseExecutionTraceAnalyzer;
import org.evosuite.coverage.dataflow.DefUseFitnessCalculator;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.RawControlFlowGraph;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.utils.ArrayUtil;

public class DefUseCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1L;
    public static long singleFitnessTime = 0L;
    private static final boolean DEBUG = Properties.DEFUSE_DEBUG_MODE;
    private static final boolean PRINT_DEBUG = false;
    private String goalVariable;
    private transient Use goalUse;
    private transient Definition goalDefinition;
    private DefUsePairType type;
    private TestFitnessFunction goalDefinitionFitness;
    private TestFitnessFunction goalUseFitness;
    private Integer coveringObjectId = -1;
    private transient ExecutionTrace coveringTrace = null;
    private boolean covered = false;

    public DefUseCoverageTestFitness(Definition def, Use use, DefUsePairType type) {
        Objects.requireNonNull(def, "null given for definition. type: " + type.toString());
        Objects.requireNonNull(use, "null given for use. def was " + def.toString() + ". type: " + type.toString());
        this.initRegularDefUse(def, use, type);
    }

    public DefUseCoverageTestFitness(Use use) {
        if (!use.isParameterUse()) {
            throw new IllegalArgumentException("this constructor is only for Parameter-Uses");
        }
        this.initParameterUse(use);
    }

    private void initRegularDefUse(Definition def, Use use, DefUsePairType type) {
        if (def.isLocalDU() && !type.equals((Object)DefUsePairType.INTRA_METHOD)) {
            throw new IllegalArgumentException("local variables can only be part of INTRA-METHOD pairs: \ntype:" + type.toString() + "\ndef:" + def.toString() + "\nuse:" + use.toString());
        }
        this.goalDefinition = def;
        this.goalUse = use;
        this.goalVariable = def.getVariableName();
        this.goalDefinitionFitness = new StatementCoverageTestFitness(this.goalDefinition.getClassName(), this.goalDefinition.getMethodName(), this.goalDefinition.getInstructionId());
        this.goalUseFitness = new StatementCoverageTestFitness(this.goalUse.getClassName(), this.goalUse.getMethodName(), this.goalUse.getInstructionId());
        this.type = type;
    }

    private void initParameterUse(Use use) {
        this.goalVariable = use.getVariableName();
        this.goalDefinition = null;
        this.goalDefinitionFitness = null;
        this.goalUse = use;
        this.goalUseFitness = new StatementCoverageTestFitness(this.goalUse.getClassName(), this.goalUse.getMethodName(), this.goalUse.getInstructionId());
        this.type = DefUsePairType.PARAMETER;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        this.preFitnessDebugInfo(result, true);
        long start = System.currentTimeMillis();
        DefUseFitnessCalculator calculator = new DefUseFitnessCalculator(this, individual, result);
        boolean archive = Properties.TEST_ARCHIVE;
        Properties.TEST_ARCHIVE = false;
        double fitness = calculator.calculateDUFitness();
        Properties.TEST_ARCHIVE = archive;
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && fitness == 0.0) {
            this.setCovered(individual, result.getTrace(), -1);
        }
        this.postFitnessDebugInfo(individual, result, fitness);
        singleFitnessTime += System.currentTimeMillis() - start;
        this.updateIndividual(individual, fitness);
        return fitness;
    }

    @Override
    public double getFitness(ExecutionResult result) {
        TestChromosome dummy = new TestChromosome();
        return this.getFitness(dummy, result);
    }

    public boolean isAlias() {
        return this.goalDefinition != null && !this.goalUse.getVariableName().equals(this.goalDefinition.getVariableName());
    }

    public Set<BytecodeInstruction> getPotentialOverwritingDefinitions() {
        Set<BytecodeInstruction> instructionsInBetween = this.getInstructionsInBetweenDU();
        if (this.goalDefinition != null) {
            return DefUseExecutionTraceAnalyzer.getOverwritingDefinitionsIn(this.goalDefinition, instructionsInBetween);
        }
        return DefUseExecutionTraceAnalyzer.getDefinitionsIn(this.goalVariable, instructionsInBetween);
    }

    public Set<BytecodeInstruction> getInstructionsInBetweenDU() {
        Set<BytecodeInstruction> previousInstructions = this.getInstructionsBeforeGoalUse();
        if (this.goalDefinition != null) {
            Set<BytecodeInstruction> laterInstructions = this.getInstructionsAfterGoalDefinition();
            if (this.goalDefinition.getInstructionId() < this.goalUse.getInstructionId() && this.goalDefinition.getMethodName().equals(this.goalUse.getMethodName())) {
                previousInstructions.retainAll(laterInstructions);
            } else {
                previousInstructions.addAll(laterInstructions);
            }
        }
        return previousInstructions;
    }

    public Set<BytecodeInstruction> getInstructionsAfterGoalDefinition() {
        RawControlFlowGraph cfg = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getRawCFG(this.goalDefinition.getClassName(), this.goalDefinition.getMethodName());
        BytecodeInstruction defVertex = cfg.getInstruction(this.goalDefinition.getInstructionId());
        Set<BytecodeInstruction> r = cfg.getLaterInstructionsInMethod(defVertex);
        return r;
    }

    public Set<BytecodeInstruction> getInstructionsBeforeGoalUse() {
        RawControlFlowGraph cfg = GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getRawCFG(this.goalUse.getClassName(), this.goalUse.getMethodName());
        BytecodeInstruction useVertex = cfg.getInstruction(this.goalUse.getInstructionId());
        Set<BytecodeInstruction> r = cfg.getPreviousInstructionsInMethod(useVertex);
        return r;
    }

    public void setCovered(TestChromosome individual, ExecutionTrace trace, Integer objectId) {
        this.coveringObjectId = objectId;
        this.updateIndividual(individual, 0.0);
        if (DEBUG && !DefUseFitnessCalculator.traceCoversGoal(this, individual, trace)) {
            throw new IllegalStateException("calculation flawed. goal wasn't covered");
        }
    }

    private void preFitnessDebugInfo(ExecutionResult result, boolean respectPrintFlag) {
        if (!respectPrintFlag) {
            System.out.println("==============================================================");
            System.out.println("current goal: " + this.toString());
            System.out.println("current test:");
            System.out.println(result.test.toCode());
        }
    }

    private void postFitnessDebugInfo(Chromosome<?> individual, ExecutionResult result, double fitness) {
        if (DEBUG && fitness != 0.0 && DefUseFitnessCalculator.traceCoversGoal(this, individual, result.getTrace())) {
            throw new IllegalStateException("calculation flawed. goal was covered but fitness was " + fitness);
        }
    }

    public ExecutionTrace getCoveringTrace() {
        return this.coveringTrace;
    }

    public String getGoalVariable() {
        return this.goalVariable;
    }

    public int getCoveringObjectId() {
        return this.coveringObjectId;
    }

    public Definition getGoalDefinition() {
        return this.goalDefinition;
    }

    public Use getGoalUse() {
        return this.goalUse;
    }

    public TestFitnessFunction getGoalUseFitness() {
        return this.goalUseFitness;
    }

    public TestFitnessFunction getGoalDefinitionFitness() {
        return this.goalDefinitionFitness;
    }

    public boolean isInterMethodPair() {
        return this.type.equals((Object)DefUsePairType.INTER_METHOD);
    }

    public boolean isIntraClassPair() {
        return this.type.equals((Object)DefUsePairType.INTRA_CLASS);
    }

    public DefUsePairType getType() {
        return this.type;
    }

    public boolean isParameterGoal() {
        return this.goalDefinition == null;
    }

    public String toString() {
        StringBuffer r = new StringBuffer();
        r.append(this.type.toString());
        r.append("-Definition-Use-Pair");
        r.append("\n\t");
        if (this.isParameterGoal()) {
            r.append("Parameter-Definition " + this.goalUse.getLocalVariableSlot() + " for method " + this.goalUse.getMethodName());
        } else {
            r.append(this.goalDefinition.toString());
        }
        r.append("\n\t");
        r.append(this.goalUse.toString());
        return r.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.goalDefinition == null ? 0 : this.goalDefinition.hashCode());
        result = 31 * result + (this.goalUse == null ? 0 : this.goalUse.hashCode());
        result = 31 * result + (this.goalVariable == null ? 0 : this.goalVariable.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefUseCoverageTestFitness other = (DefUseCoverageTestFitness)obj;
        if (this.goalDefinition == null ? other.goalDefinition != null : !this.goalDefinition.equals(other.goalDefinition)) {
            return false;
        }
        if (this.goalUse == null ? other.goalUse != null : !this.goalUse.equals(other.goalUse)) {
            return false;
        }
        if (this.goalVariable == null ? other.goalVariable != null : !this.goalVariable.equals(other.goalVariable)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof DefUseCoverageTestFitness) {
            DefUseCoverageTestFitness otherFitness = (DefUseCoverageTestFitness)other;
            if (this.goalDefinition == null || otherFitness.getGoalDefinition() == null) {
                return this.goalUse.compareTo(otherFitness.getGoalUse());
            }
            if (this.goalDefinition.compareTo(otherFitness.getGoalDefinition()) == 0) {
                return this.goalUse.compareTo(otherFitness.getGoalUse());
            }
            return this.goalDefinition.compareTo(otherFitness.getGoalDefinition());
        }
        return this.compareClassName(other);
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean covered) {
        this.covered = covered;
    }

    @Override
    public String getTargetClass() {
        return this.goalUse.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.goalUse.getMethodName();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        DefUsePairType type = (DefUsePairType)((Object)ois.readObject());
        Integer useId = (Integer)ois.readObject();
        Integer defId = (Integer)ois.readObject();
        Use use = DefUsePool.getUseByUseId(useId);
        if (use == null) {
            return;
        }
        if (type == DefUsePairType.PARAMETER) {
            this.initParameterUse(use);
        } else {
            Definition def = DefUsePool.getDefinitionByDefId(defId);
            this.initRegularDefUse(def, use, type);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject((Object)this.type);
        oos.writeObject(this.goalUse.useId);
        if (this.goalDefinition != null) {
            oos.writeObject(this.goalDefinition.defId);
        } else {
            oos.writeObject(0);
        }
    }

    public static enum DefUsePairType {
        INTRA_METHOD,
        INTER_METHOD,
        INTRA_CLASS,
        PARAMETER;

    }
}

