/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.ibranch.IBranchTestFitness;
import org.evosuite.setup.CallContext;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBranchFitnessFactory
extends AbstractFitnessFactory<IBranchTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(IBranchFitnessFactory.class);

    @Override
    public List<IBranchTestFitness> getCoverageGoals() {
        HashSet<IBranchTestFitness> goals = new HashSet<IBranchTestFitness>();
        BranchCoverageFactory branchFactory = new BranchCoverageFactory();
        List<BranchCoverageTestFitness> branchGoals = branchFactory.getCoverageGoalsForAllKnownClasses();
        CallGraph callGraph = DependencyAnalysis.getCallGraph();
        for (BranchCoverageTestFitness branchGoal : branchGoals) {
            logger.info("Adding context branches for " + branchGoal.toString());
            for (CallContext context : callGraph.getAllContextsFromTargetClass(branchGoal.getClassName(), branchGoal.getMethod())) {
                if (context.isEmpty()) continue;
                goals.add(new IBranchTestFitness(branchGoal.getBranchGoal(), context));
            }
        }
        assert (goals.size() >= branchFactory.getCoverageGoals().size());
        logger.info("Created " + goals.size() + " goals");
        return new ArrayList<IBranchTestFitness>(goals);
    }
}

