/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ibranch;

import org.evosuite.coverage.ibranch.IBranchSuiteFitness;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testsuite.TestSuiteChromosome;

public class IBranchSecondaryObjective
extends SecondaryObjective<TestSuiteChromosome> {
    private IBranchSuiteFitness ff = new IBranchSuiteFitness();
    private static final long serialVersionUID = 7211557650429998223L;

    @Override
    public int compareChromosomes(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        double fitness1 = this.ff.getFitness(chromosome1, false);
        double fitness2 = this.ff.getFitness(chromosome2, false);
        int i = (int)Math.signum(fitness1 - fitness2);
        this.ff.updateCoveredGoals();
        return i;
    }

    @Override
    public int compareGenerations(TestSuiteChromosome parent1, TestSuiteChromosome parent2, TestSuiteChromosome child1, TestSuiteChromosome child2) {
        logger.debug("Comparing sizes: " + parent1.size() + ", " + parent1.size() + " vs " + child1.size() + ", " + child2.size());
        if (!parent1.hasExecutedFitness(this.ff) || parent1.isChanged()) {
            this.ff.getFitness(parent1);
        }
        if (!parent2.hasExecutedFitness(this.ff) || parent2.isChanged()) {
            this.ff.getFitness(parent2);
        }
        if (!child1.hasExecutedFitness(this.ff) || child1.isChanged()) {
            this.ff.getFitness(child1);
        }
        if (!child2.hasExecutedFitness(this.ff) || child2.isChanged()) {
            this.ff.getFitness(child2);
        }
        double minParents = Math.min(parent1.getFitness(this.ff), parent2.getFitness(this.ff));
        double minChildren = Math.min(child1.getFitness(this.ff), child2.getFitness(this.ff));
        return Double.compare(minParents, minChildren);
    }
}

