/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorManager;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.shaded.org.objectweb.asm.Type;

public class InputCoverageGoal
implements Serializable,
Comparable<InputCoverageGoal> {
    private static final long serialVersionUID = -2917009638438833179L;
    private final String className;
    private final String methodName;
    private final int argIndex;
    private final String type;
    private final String valueDescriptor;
    private final Number numericValue;

    public InputCoverageGoal(String className, String methodName, int argIndex, Type type, String valueDescriptor) {
        this(className, methodName, argIndex, type, valueDescriptor, null);
    }

    public InputCoverageGoal(String className, String methodName, int argIndex, Type type, String valueDescriptor, Number numericValue) {
        if (className == null || methodName == null) {
            throw new IllegalArgumentException("null given");
        }
        this.className = className;
        this.methodName = methodName;
        this.argIndex = argIndex;
        this.type = type.toString();
        this.valueDescriptor = valueDescriptor;
        this.numericValue = numericValue;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getArgIndex() {
        return this.argIndex;
    }

    public Type getType() {
        return Type.getType(this.type);
    }

    public String getValueDescriptor() {
        return this.valueDescriptor;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public String toString() {
        return this.className + "." + this.methodName + "[" + this.argIndex + "]:" + this.valueDescriptor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.className.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.argIndex;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.valueDescriptor == null ? 0 : this.valueDescriptor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputCoverageGoal other = (InputCoverageGoal)obj;
        if (this.argIndex != other.argIndex) {
            return false;
        }
        if (!this.methodName.equals(other.methodName) && this.className.equals(other.className)) {
            return false;
        }
        if (this.type == null && other.type != null || this.type != null && other.type == null) {
            return false;
        }
        if (this.type != null && !this.type.equals(other.type)) {
            return false;
        }
        if (this.valueDescriptor == null && other.valueDescriptor != null || this.valueDescriptor != null && other.valueDescriptor == null) {
            return false;
        }
        return this.valueDescriptor == null || this.valueDescriptor.equals(other.valueDescriptor);
    }

    @Override
    public int compareTo(InputCoverageGoal o) {
        int diff = this.className.compareTo(o.className);
        if (diff == 0) {
            int diff2 = this.methodName.compareTo(o.methodName);
            if (diff2 == 0) {
                if (this.argIndex == o.argIndex) {
                    int diff3 = this.type.compareTo(o.type);
                    if (diff3 == 0) {
                        return this.valueDescriptor.compareTo(o.valueDescriptor);
                    }
                    return diff3;
                }
                return Integer.compare(this.argIndex, o.argIndex);
            }
            return diff2;
        }
        return diff;
    }

    public static Set<InputCoverageGoal> createCoveredGoalsFromParameters(String className, String methodName, String methodDesc, List<Object> argumentsValues) {
        LinkedHashSet<InputCoverageGoal> goals = new LinkedHashSet<InputCoverageGoal>();
        Type[] argTypes = Type.getArgumentTypes(methodDesc);
        block10: for (int i = 0; i < argTypes.length; ++i) {
            Type argType = argTypes[i];
            Object argValue = argumentsValues.get(i);
            String argValueDesc = "";
            Number numberValue = null;
            if (argValue == null) {
                argValueDesc = "Null";
                goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                continue;
            }
            int typeSort = argType.getSort();
            if (typeSort == 10 && ClassUtils.isPrimitiveWrapper(argValue.getClass())) {
                typeSort = Type.getType(ClassUtils.wrapperToPrimitive(argValue.getClass())).getSort();
            }
            switch (typeSort) {
                case 1: {
                    argValueDesc = (Boolean)argValue != false ? "True" : "False";
                    goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                    continue block10;
                }
                case 2: {
                    char c = ((Character)argValue).charValue();
                    numberValue = c;
                    argValueDesc = Character.isAlphabetic(c) ? "AlphabeticChar" : (Character.isDigit(c) ? "Digit" : "OtherChar");
                    goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                    continue block10;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    double value = argValue instanceof Character ? ((Number)Integer.valueOf(((Character)argValue).charValue())).doubleValue() : ((Number)argValue).doubleValue();
                    numberValue = value;
                    argValueDesc = value < 0.0 ? "Negative" : (value == 0.0 ? "Zero" : "Positive");
                    goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                    continue block10;
                }
                case 9: {
                    argValueDesc = Array.getLength(argValue) == 0 ? "EmptyArray" : "NonEmptyArray";
                    goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                    continue block10;
                }
                case 10: {
                    if (argType.getClassName().equals("java.lang.String")) {
                        argValueDesc = ((String)argValue).isEmpty() ? "EmptyString" : "NonEmptyString";
                        goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                        continue block10;
                    }
                    if (argValue instanceof List) {
                        argValueDesc = ((List)argValue).isEmpty() ? "EmptyList" : "NonEmptyList";
                        goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                        continue block10;
                    }
                    if (argValue instanceof Set) {
                        argValueDesc = ((Set)argValue).isEmpty() ? "EmptySet" : "NonEmptySet";
                        goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                        continue block10;
                    }
                    if (argValue instanceof Map) {
                        argValueDesc = ((Map)argValue).isEmpty() ? "EmptyMap" : "NonEmptyMap";
                        goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                        continue block10;
                    }
                    List<Inspector> inspectors = InspectorManager.getInstance().getInspectors(argValue.getClass());
                    for (Inspector inspector : inspectors) {
                        String insp = inspector.getMethodCall() + Type.getMethodDescriptor(inspector.getMethod());
                        try {
                            Object val = inspector.getValue(argValue);
                            if (val instanceof Boolean) {
                                String valDesc = (Boolean)val != false ? "True" : "False";
                                goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, "NonNull:" + argType.getClassName() + ":" + insp + ":" + valDesc));
                                continue;
                            }
                            if (!InputCoverageGoal.isJavaNumber(val)) continue;
                            double dv = ((Number)val).doubleValue();
                            String valDesc = dv < 0.0 ? "Negative" : (dv == 0.0 ? "Zero" : "Positive");
                            goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, "NonNull:" + argType.getClassName() + ":" + insp + ":" + valDesc));
                        }
                        catch (InvocationTargetException invocationTargetException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    if (!inspectors.isEmpty()) continue block10;
                    argValueDesc = "NonNull";
                    goals.add(new InputCoverageGoal(className, methodName + methodDesc, i, argType, argValueDesc, numberValue));
                    continue block10;
                }
            }
        }
        return goals;
    }

    private static boolean isJavaNumber(Object val) {
        return val instanceof Number && val.getClass().getName().startsWith("java.");
    }
}

