/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.io.input;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.io.input.InputCoverageFactory;
import org.evosuite.coverage.io.input.InputCoverageTestFitness;
import org.evosuite.coverage.io.input.InputObserver;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class InputCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -6571466037158036014L;
    private final int totalGoals;
    private final Set<InputCoverageTestFitness> inputCoverageMap = new LinkedHashSet<InputCoverageTestFitness>();
    private Set<InputCoverageTestFitness> toRemoveGoals = new LinkedHashSet<InputCoverageTestFitness>();
    private Set<InputCoverageTestFitness> removedGoals = new LinkedHashSet<InputCoverageTestFitness>();
    private int maxCoveredGoals = 0;
    private double bestFitness = Double.MAX_VALUE;

    public InputCoverageSuiteFitness() {
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        InputObserver observer = new InputObserver();
        executor.addObserver(observer);
        this.determineCoverageGoals();
        this.totalGoals = this.inputCoverageMap.size();
    }

    private void determineCoverageGoals() {
        List<InputCoverageTestFitness> goals = new InputCoverageFactory().getCoverageGoals();
        for (InputCoverageTestFitness goal : goals) {
            this.inputCoverageMap.add(goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        logger.trace("Calculating test suite fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (!result.hasTimeout() && !result.hasTestException()) continue;
            hasTimeoutOrTestException = true;
            break;
        }
        LinkedHashSet<TestFitnessFunction> setOfCoveredGoals = new LinkedHashSet<TestFitnessFunction>();
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.totalGoals);
            fitness = this.totalGoals;
        } else {
            fitness = this.computeDistance(results, setOfCoveredGoals);
        }
        int coveredGoals = setOfCoveredGoals.size() + this.removedGoals.size();
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coveredGoals / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coveredGoals);
        this.printStatusMessages(suite, coveredGoals, fitness);
        this.updateIndividual(suite, fitness);
        assert (coveredGoals <= this.totalGoals) : "Covered " + coveredGoals + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coveredGoals == this.totalGoals) : "Fitness: " + fitness + ", coverage: " + coveredGoals + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (InputCoverageTestFitness goal : this.toRemoveGoals) {
            if (this.inputCoverageMap.remove(goal)) {
                this.removedGoals.add(goal);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveGoals.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        return true;
    }

    private double computeDistance(List<ExecutionResult> results, Set<TestFitnessFunction> setOfCoveredGoals) {
        LinkedHashMap<InputCoverageTestFitness, Double> mapDistances = new LinkedHashMap<InputCoverageTestFitness, Double>();
        for (InputCoverageTestFitness testFitness : this.inputCoverageMap) {
            mapDistances.put(testFitness, 1.0);
        }
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) continue;
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (InputCoverageTestFitness testFitness : this.inputCoverageMap) {
                if (!mapDistances.containsKey(testFitness)) continue;
                double distance = testFitness.getFitness(test, result);
                mapDistances.put(testFitness, Math.min(distance, (Double)mapDistances.get(testFitness)));
                if (distance != 0.0) continue;
                mapDistances.remove(testFitness);
                setOfCoveredGoals.add(testFitness);
                this.toRemoveGoals.add(testFitness);
            }
        }
        return mapDistances.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    private void printStatusMessages(TestSuiteChromosome suite, int coveredGoals, double fitness) {
        if (coveredGoals > this.maxCoveredGoals) {
            logger.info("(Input Goals) Best individual covers " + coveredGoals + "/" + this.totalGoals + " input goals");
            this.maxCoveredGoals = coveredGoals;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredGoals + "/" + this.totalGoals + " input goals");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }
}

