/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -6369027784777941998L;
    private static final Logger logger = LoggerFactory.getLogger(LineCoverageSuiteFitness.class);
    private final int numLines;
    private final Map<Integer, TestFitnessFunction> lineGoals = new LinkedHashMap<Integer, TestFitnessFunction>();
    private final Set<Integer> removedLines = new LinkedHashSet<Integer>();
    private final Set<Integer> toRemoveLines = new LinkedHashSet<Integer>();
    private int maxCoveredLines = 0;
    private double bestFitness = Double.MAX_VALUE;
    private final Set<Integer> branchesToCoverTrue = new LinkedHashSet<Integer>();
    private final Set<Integer> branchesToCoverFalse = new LinkedHashSet<Integer>();
    private final Set<Integer> branchesToCoverBoth = new LinkedHashSet<Integer>();

    public LineCoverageSuiteFitness() {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        List<LineCoverageTestFitness> goals = new LineCoverageFactory().getCoverageGoals();
        for (LineCoverageTestFitness goal : goals) {
            this.lineGoals.put(goal.getLine(), goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
        this.numLines = this.lineGoals.size();
        logger.info("Total line coverage goals: " + this.numLines);
        this.initializeControlDependencies();
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (Integer goalID : this.toRemoveLines) {
            TestFitnessFunction ff = this.lineGoals.remove(goalID);
            if (ff != null) {
                this.removedLines.add(goalID);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveLines.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        assert (this.numLines == this.lineGoals.size() + this.removedLines.size());
        return true;
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Set<Integer> coveredLines) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Integer goalID : this.lineGoals.keySet()) {
                TestFitnessFunction goal = this.lineGoals.get(goalID);
                double fit = goal.getFitness(test, result);
                if (fit != 0.0) continue;
                coveredLines.add(goalID);
                this.toRemoveLines.add(goalID);
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        logger.info("Branch distances: " + (fitness += this.getControlDependencyGuidance(results)));
        LinkedHashSet<Integer> coveredLines = new LinkedHashSet<Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, coveredLines);
        int totalLines = this.numLines;
        int numCoveredLines = coveredLines.size() + this.removedLines.size();
        logger.debug("Covered " + numCoveredLines + " out of " + totalLines + " lines, " + this.removedLines.size() + " in archive");
        this.printStatusMessages(suite, numCoveredLines, fitness += LineCoverageSuiteFitness.normalize(totalLines - numCoveredLines));
        if (totalLines > 0) {
            suite.setCoverage(this, (double)numCoveredLines / (double)totalLines);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, numCoveredLines);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + totalLines);
            fitness = totalLines;
        }
        this.updateIndividual(suite, fitness);
        assert (numCoveredLines <= totalLines) : "Covered " + numCoveredLines + " vs total goals " + totalLines;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || numCoveredLines == totalLines) : "Fitness: " + fitness + ", coverage: " + numCoveredLines + "/" + totalLines;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    private void printStatusMessages(TestSuiteChromosome suite, int coveredLines, double fitness) {
        if (coveredLines > this.maxCoveredLines) {
            this.maxCoveredLines = coveredLines;
            logger.info("(Lines) Best individual covers " + coveredLines + "/" + this.numLines + " lines");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredLines + "/" + this.numLines + " lines");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }

    private void initializeControlDependencies() {
        LinkedHashSet<String> targetClasses = new LinkedHashSet<String>();
        for (TestFitnessFunction ff : this.lineGoals.values()) {
            targetClasses.add(ff.getTargetClass());
        }
        for (String className : targetClasses) {
            List<BytecodeInstruction> instructions = BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getInstructionsIn(className);
            if (instructions == null) {
                logger.info("No instructions known for class {} (is it an enum?)", (Object)className);
                continue;
            }
            for (BytecodeInstruction bi : instructions) {
                if (bi.getBasicBlock() == null) continue;
                ArrayList<ControlDependency> cds = new ArrayList<ControlDependency>(bi.getControlDependencies());
                Collections.sort(cds);
                for (ControlDependency cd : cds) {
                    if (cd.getBranchExpressionValue()) {
                        this.branchesToCoverTrue.add(cd.getBranch().getActualBranchId());
                        continue;
                    }
                    this.branchesToCoverFalse.add(cd.getBranch().getActualBranchId());
                }
            }
        }
        this.branchesToCoverBoth.addAll(this.branchesToCoverTrue);
        this.branchesToCoverBoth.retainAll(this.branchesToCoverFalse);
        this.branchesToCoverTrue.removeAll(this.branchesToCoverBoth);
        this.branchesToCoverFalse.removeAll(this.branchesToCoverBoth);
        logger.info("Covering branches true: " + this.branchesToCoverTrue);
        logger.info("Covering branches false: " + this.branchesToCoverFalse);
        logger.info("Covering branches both: " + this.branchesToCoverBoth);
    }

    private double getControlDependencyGuidance(List<ExecutionResult> results) {
        LinkedHashMap predicateCount = new LinkedHashMap();
        LinkedHashMap trueDistance = new LinkedHashMap();
        LinkedHashMap falseDistance = new LinkedHashMap();
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) continue;
            for (Map.Entry entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
                if (!predicateCount.containsKey(entry.getKey())) {
                    predicateCount.put(entry.getKey(), entry.getValue());
                    continue;
                }
                predicateCount.put(entry.getKey(), (Integer)predicateCount.get(entry.getKey()) + (Integer)entry.getValue());
            }
            for (Map.Entry entry : result.getTrace().getTrueDistances().entrySet()) {
                if (!trueDistance.containsKey(entry.getKey())) {
                    trueDistance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                trueDistance.put(entry.getKey(), Math.min((Double)trueDistance.get(entry.getKey()), (Double)entry.getValue()));
            }
            for (Map.Entry entry : result.getTrace().getFalseDistances().entrySet()) {
                if (!falseDistance.containsKey(entry.getKey())) {
                    falseDistance.put(entry.getKey(), entry.getValue());
                    continue;
                }
                falseDistance.put(entry.getKey(), Math.min((Double)falseDistance.get(entry.getKey()), (Double)entry.getValue()));
            }
        }
        double distance = 0.0;
        for (Integer n : this.branchesToCoverBoth) {
            if (!predicateCount.containsKey(n)) {
                distance += 2.0;
                continue;
            }
            if ((Integer)predicateCount.get(n) == 1) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)trueDistance.get(n));
            distance += LineCoverageSuiteFitness.normalize((Double)falseDistance.get(n));
        }
        for (Integer n : this.branchesToCoverTrue) {
            if (!trueDistance.containsKey(n)) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)trueDistance.get(n));
        }
        for (Integer n : this.branchesToCoverFalse) {
            if (!falseDistance.containsKey(n)) {
                distance += 1.0;
                continue;
            }
            distance += LineCoverageSuiteFitness.normalize((Double)falseDistance.get(n));
        }
        return distance;
    }
}

