/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.line;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.graphs.GraphPool;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.graphs.cfg.BytecodeInstructionPool;
import org.evosuite.graphs.cfg.ControlDependency;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;

public class LineCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 3624503060256855484L;
    private final String className;
    private final String methodName;
    private final Integer line;
    protected transient BytecodeInstruction goalInstruction;
    protected transient List<BranchCoverageTestFitness> branchFitnesses = new ArrayList<BranchCoverageTestFitness>();

    public LineCoverageTestFitness(String className, String methodName, Integer line) {
        this.className = Objects.requireNonNull(className, "className cannot be null");
        this.methodName = Objects.requireNonNull(methodName, "methodName cannot be null");
        this.line = Objects.requireNonNull(line, "line number cannot be null");
        this.setupDependencies();
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    public Integer getLine() {
        return this.line;
    }

    private void setupDependencies() {
        this.goalInstruction = BytecodeInstructionPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getFirstInstructionAtLineNumber(this.className, this.methodName, this.line);
        if (this.goalInstruction == null) {
            return;
        }
        Set<ControlDependency> cds = this.goalInstruction.getControlDependencies();
        for (ControlDependency cd : cds) {
            BranchCoverageTestFitness fitness = BranchCoverageFactory.createBranchCoverageTestFitness(cd);
            this.branchFitnesses.add(fitness);
        }
        if (this.goalInstruction.isRootBranchDependent()) {
            this.branchFitnesses.add(BranchCoverageFactory.createRootBranchTestFitness(this.goalInstruction));
        }
        if (cds.isEmpty() && !this.goalInstruction.isRootBranchDependent()) {
            throw new IllegalStateException("expect control dependencies to be empty only for root dependent instructions: " + this.toString());
        }
        if (this.branchFitnesses.isEmpty()) {
            throw new IllegalStateException("an instruction is at least on the root branch of it's method");
        }
        this.branchFitnesses.sort(Comparator.naturalOrder());
    }

    @Override
    public boolean isCovered(ExecutionResult result) {
        Stream coveredLines = result.getTrace().getCoveredLines().stream();
        return coveredLines.anyMatch(coveredLine -> coveredLine.intValue() == this.line.intValue());
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        boolean archive = Properties.TEST_ARCHIVE;
        Properties.TEST_ARCHIVE = false;
        if (result.getTrace().getCoveredLines().contains(this.line)) {
            fitness = 0.0;
        } else {
            double r = Double.MAX_VALUE;
            for (BranchCoverageTestFitness branchFitness : this.branchFitnesses) {
                double newFitness = branchFitness.getFitness(individual, result);
                if (newFitness == 0.0) {
                    individual.getTestCase().removeCoveredGoal(branchFitness);
                    newFitness = 1.0;
                } else {
                    newFitness = 1.0 + LineCoverageTestFitness.normalize(newFitness);
                }
                if (!(newFitness < r)) continue;
                r = newFitness;
            }
            fitness = r;
        }
        Properties.TEST_ARCHIVE = archive;
        this.updateIndividual(individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    public String toString() {
        return this.className + (this.methodName.isEmpty() ? "" : "." + this.methodName) + ": Line " + this.line;
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode() + iConst + this.line.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LineCoverageTestFitness other = (LineCoverageTestFitness)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.line.intValue() == other.line.intValue();
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other == null) {
            return 1;
        }
        if (other instanceof LineCoverageTestFitness) {
            LineCoverageTestFitness otherLineFitness = (LineCoverageTestFitness)other;
            if (this.className.compareTo(otherLineFitness.getClassName()) != 0) {
                return this.className.compareTo(otherLineFitness.getClassName());
            }
            if (this.methodName.compareTo(otherLineFitness.getMethod()) != 0) {
                return this.methodName.compareTo(otherLineFitness.getMethod());
            }
            return this.line.compareTo(otherLineFitness.getLine());
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.branchFitnesses = new ArrayList<BranchCoverageTestFitness>();
        if (GraphPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getActualCFG(this.className, this.methodName) != null) {
            this.setupDependencies();
        }
    }

    private void writeObject(ObjectOutputStream oos) throws ClassNotFoundException, IOException {
        oos.defaultWriteObject();
    }
}

