/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.method;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.evosuite.Properties;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;

public class MethodCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 3624503060256855484L;
    protected final String className;
    protected final String methodName;

    public MethodCoverageTestFitness(String className, String methodName) {
        this.className = Objects.requireNonNull(className, "className cannot be null");
        this.methodName = Objects.requireNonNull(methodName, "methodName cannot be null");
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethod() {
        return this.methodName;
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        Statement stmt;
        double fitness = 1.0;
        List<Integer> exceptionPositions = this.asSortedList(result.getPositionsWhereExceptionsWereThrown());
        Iterator iterator = result.test.iterator();
        while (iterator.hasNext() && this.isValidPosition(exceptionPositions, (stmt = (Statement)iterator.next()).getPosition())) {
            if (!(stmt instanceof MethodStatement) && !(stmt instanceof ConstructorStatement)) continue;
            EntityWithParametersStatement ps = (EntityWithParametersStatement)stmt;
            String className = ps.getDeclaringClassName();
            String methodDesc = ps.getDescriptor();
            String methodName = ps.getMethodName() + methodDesc;
            if (!this.className.equals(className) || !this.methodName.equals(methodName)) continue;
            fitness = 0.0;
            break;
        }
        this.updateIndividual(individual, fitness);
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    private boolean isValidPosition(List<Integer> exceptionPositions, Integer position) {
        if (Properties.BREAK_ON_EXCEPTION) {
            return exceptionPositions.isEmpty() || position <= exceptionPositions.get(0);
        }
        return true;
    }

    private <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public String toString() {
        return "[METHOD] " + this.className + "." + this.methodName;
    }

    @Override
    public int hashCode() {
        int iConst = 13;
        return 51 * iConst + this.className.hashCode() * iConst + this.methodName.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodCoverageTestFitness other = (MethodCoverageTestFitness)obj;
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.methodName.equals(other.methodName);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof MethodCoverageTestFitness) {
            MethodCoverageTestFitness otherMethodFitness = (MethodCoverageTestFitness)other;
            if (this.className.equals(otherMethodFitness.getClassName())) {
                return this.methodName.compareTo(otherMethodFitness.getMethod());
            }
            return this.className.compareTo(otherMethodFitness.getClassName());
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.getClassName();
    }

    @Override
    public String getTargetMethod() {
        return this.getMethod();
    }
}

