/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.mutation;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationFactory;
import org.evosuite.coverage.mutation.MutationTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public abstract class MutationSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -8320078404661057113L;
    protected final BranchCoverageSuiteFitness branchFitness;
    protected final Map<Integer, MutationTestFitness> mutantMap = new LinkedHashMap<Integer, MutationTestFitness>();
    protected final int numMutants;
    protected final Set<Integer> removedMutants = new LinkedHashSet<Integer>();
    protected final Set<Integer> toRemoveMutants = new LinkedHashSet<Integer>();

    public MutationSuiteFitness(Properties.Criterion criterion) {
        if (criterion != Properties.Criterion.STRONGMUTATION && criterion != Properties.Criterion.WEAKMUTATION && criterion != Properties.Criterion.ONLYMUTATION) {
            throw new RuntimeException("Invalid initialisation of MutationSuiteFitness with criterion '" + criterion.name() + "'. MutationSuiteFitness can only be invoked with STRONGMUTATION, WEAKMUTATION, and ONLYMUTATION");
        }
        MutationFactory factory = (MutationFactory)FitnessFunctions.getFitnessFactory(criterion);
        boolean archive = Properties.TEST_ARCHIVE;
        Properties.TEST_ARCHIVE = false;
        this.branchFitness = new BranchCoverageSuiteFitness();
        Properties.TEST_ARCHIVE = archive;
        for (MutationTestFitness goal : factory.getCoverageGoals()) {
            this.mutantMap.put(goal.getMutation().getId(), goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
        this.numMutants = this.mutantMap.size();
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (Integer mutant : this.toRemoveMutants) {
            TestFitnessFunction ff = this.mutantMap.remove(mutant);
            if (ff != null) {
                this.removedMutants.add(mutant);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveMutants.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        return true;
    }

    @Override
    public ExecutionResult runTest(TestCase test) {
        return this.runTest(test, null);
    }

    public ExecutionResult runTest(TestCase test, Mutation mutant) {
        return MutationTestFitness.runTest(test, mutant);
    }

    @Override
    public abstract double getFitness(TestSuiteChromosome var1);
}

