/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.rho;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.instrumentation.LinePool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RhoAux {
    private static final Logger logger = LoggerFactory.getLogger(RhoAux.class);

    private static boolean isCUTorNot(String className) {
        return Properties.TARGET_CLASS.equals("") || className.equals(Properties.TARGET_CLASS) || className.startsWith(Properties.TARGET_CLASS + "$");
    }

    public static List<LineCoverageTestFitness> getLineGoals() {
        ArrayList<LineCoverageTestFitness> goals = new ArrayList<LineCoverageTestFitness>();
        for (String className : LinePool.getKnownClasses()) {
            if (!RhoAux.isCUTorNot(className)) continue;
            LinkedHashSet<Integer> lines = new LinkedHashSet<Integer>();
            for (String methodName : LinePool.getKnownMethodsFor(className)) {
                lines.addAll(LinePool.getLines(className, methodName));
            }
            for (Integer line : lines) {
                logger.info("Adding line " + line + " for class '" + className + "'");
                goals.add(new LineCoverageTestFitness(className, Properties.TARGET_METHOD, line));
            }
        }
        return goals;
    }
}

