/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.statement;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.statement.StatementCoverageFactory;
import org.evosuite.coverage.statement.StatementCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class StatementCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -3037573618694670748L;
    private final int numStatements;
    private final Set<TestFitnessFunction> statementGoals = new LinkedHashSet<TestFitnessFunction>();
    private final Set<TestFitnessFunction> removedStatements = new LinkedHashSet<TestFitnessFunction>();
    private final Set<TestFitnessFunction> toRemoveStatements = new LinkedHashSet<TestFitnessFunction>();

    public StatementCoverageSuiteFitness() {
        List<StatementCoverageTestFitness> goals = new StatementCoverageFactory().getCoverageGoals();
        for (StatementCoverageTestFitness goal : goals) {
            this.statementGoals.add(goal);
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().addTarget(goal);
        }
        this.numStatements = this.statementGoals.size();
        logger.info("Total statement goals: " + this.numStatements);
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (TestFitnessFunction goal : this.toRemoveStatements) {
            if (this.statementGoals.remove(goal)) {
                this.removedStatements.add(goal);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveStatements.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        assert (this.numStatements == this.statementGoals.size() + this.removedStatements.size());
        return true;
    }

    private boolean analyzeTraces(List<ExecutionResult> results, Set<TestFitnessFunction> coveredStatements) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (TestFitnessFunction goal : this.statementGoals) {
                double fit = goal.getFitness(test, result);
                if (fit != 0.0) continue;
                coveredStatements.add(goal);
                this.toRemoveStatements.add(goal);
            }
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        List<ExecutionResult> results = this.runTestSuite(suite);
        double fitness = 0.0;
        LinkedHashSet<TestFitnessFunction> coveredStatements = new LinkedHashSet<TestFitnessFunction>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(results, coveredStatements);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + this.numStatements);
            fitness = this.numStatements;
        } else {
            int totalStatements = this.numStatements;
            int numCoveredStatements = coveredStatements.size() + this.removedStatements.size();
            suite.setNumOfCoveredGoals(this, numCoveredStatements);
            if (totalStatements > 0) {
                suite.setCoverage(this, (double)numCoveredStatements / (double)totalStatements);
            } else {
                suite.setCoverage(this, 1.0);
            }
            fitness = StatementCoverageSuiteFitness.normalize(totalStatements - numCoveredStatements);
            assert (numCoveredStatements <= totalStatements) : "Covered " + numCoveredStatements + " vs total goals " + totalStatements;
            assert (fitness >= 0.0);
            assert (fitness != 0.0 || numCoveredStatements == totalStatements) : "Fitness: " + fitness + ", coverage: " + numCoveredStatements + "/" + totalStatements;
            assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        }
        this.updateIndividual(suite, fitness);
        return fitness;
    }
}

