/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.executionmode;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.classpath.ResourceList;
import org.evosuite.executionmode.Help;
import org.evosuite.shaded.org.apache.commons.cli.CommandLine;
import org.evosuite.shaded.org.apache.commons.cli.Option;
import org.evosuite.shaded.org.apache.commons.cli.Options;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.evosuite.utils.LoggingUtils;

public class ListClasses {
    public static final String NAME = "listClasses";

    public static Option getOption() {
        return new Option(NAME, "list the testable classes found in the specified classpath/prefix");
    }

    public static Object execute(Options options, CommandLine line) {
        if (line.hasOption("prefix")) {
            ListClasses.listClassesPrefix(line.getOptionValue("prefix"));
        } else if (line.hasOption("target")) {
            ListClasses.listClassesTarget(line.getOptionValue("target"));
        } else if (EvoSuite.hasLegacyTargets()) {
            ListClasses.listClassesLegacy();
        } else {
            LoggingUtils.getEvoLogger().error("Please specify target prefix ('-prefix' option) or classpath entry ('-target' option) to list testable classes");
            Help.execute(options);
        }
        return null;
    }

    private static void listClassesTarget(String target) {
        Set<String> classes = ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(target, false);
        try {
            ClassPathHacker.addFile(target);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String sut : classes) {
            block7: {
                try {
                    if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassAnInterface(sut) || !Properties.USE_DEPRECATED && ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassDeprecated(sut)) continue;
                    if (!ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassTestable(sut)) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().error("Could not load class: " + sut);
                }
                continue;
            }
            String row = "";
            String groupId = Properties.GROUP_ID;
            if (groupId != null && !groupId.isEmpty() && !groupId.equals("none")) {
                row = row + groupId + "\t";
            }
            row = row + sut;
            LoggingUtils.getEvoLogger().info(row);
        }
    }

    private static void listClassesLegacy() {
        File directory = new File(Properties.OUTPUT_DIR);
        String[] extensions = new String[]{"task"};
        for (File file : FileUtils.listFiles(directory, extensions, false)) {
            LoggingUtils.getEvoLogger().info(file.getName().replace(".task", ""));
        }
    }

    private static void listClassesPrefix(String prefix) {
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (String classPathElement : cp.split(File.pathSeparator)) {
            classes.addAll(ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllClasses(classPathElement, prefix, false));
            try {
                ClassPathHacker.addFile(classPathElement);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (String sut : classes) {
            block7: {
                try {
                    if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isClassAnInterface(sut)) {
                    }
                    break block7;
                }
                catch (IOException e) {
                    LoggingUtils.getEvoLogger().error("Could not load class: " + sut);
                }
                continue;
            }
            LoggingUtils.getEvoLogger().info(sut);
        }
    }
}

