/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.SelfTyped;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.utils.PublicCloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Chromosome<T extends Chromosome<T>>
implements Comparable<T>,
Serializable,
PublicCloneable<T>,
SelfTyped<T> {
    private static final long serialVersionUID = -6921897301005213358L;
    private static final Logger logger = LoggerFactory.getLogger(Chromosome.class);
    private final LinkedHashMap<FitnessFunction<T>, Double> fitnessValues = new LinkedHashMap();
    private final LinkedHashMap<FitnessFunction<T>, Double> previousFitnessValues = new LinkedHashMap();
    private boolean changed = true;
    private boolean localSearchApplied = false;
    private final LinkedHashMap<FitnessFunction<T>, Double> coverageValues = new LinkedHashMap();
    private final LinkedHashMap<FitnessFunction<T>, Integer> numsNotCoveredGoals = new LinkedHashMap();
    private final LinkedHashMap<FitnessFunction<T>, Integer> numsCoveredGoals = new LinkedHashMap();
    protected int age = 0;
    protected int rank = -1;
    protected double distance = 0.0;
    private int numberOfMutations = 0;
    private int numberOfEvaluations = 0;
    protected double kineticEnergy = Properties.INITIAL_KINETIC_ENERGY;
    protected int numCollisions = 0;

    protected Chromosome() {
    }

    public double getFitness() {
        return this.fitnessValues.values().stream().mapToDouble(Double::doubleValue).sum();
    }

    public double getFitness(FitnessFunction<T> ff) {
        return this.fitnessValues.containsKey(ff) ? this.fitnessValues.get(ff).doubleValue() : ff.getFitness((Chromosome)this.self());
    }

    public Map<FitnessFunction<T>, Double> getFitnessValues() {
        return this.fitnessValues;
    }

    public Map<FitnessFunction<T>, Double> getPreviousFitnessValues() {
        return this.previousFitnessValues;
    }

    public boolean hasExecutedFitness(FitnessFunction<T> ff) {
        return this.previousFitnessValues.containsKey(ff);
    }

    public void setFitnessValues(Map<? extends FitnessFunction<T>, Double> fits) {
        this.fitnessValues.clear();
        this.fitnessValues.putAll(fits);
    }

    public void setPreviousFitnessValues(Map<FitnessFunction<T>, Double> lastFits) {
        this.previousFitnessValues.clear();
        this.previousFitnessValues.putAll(lastFits);
    }

    public void addFitness(FitnessFunction<T> ff) {
        double fitnessValue = ff.isMaximizationFunction() ? 0.0 : Double.MAX_VALUE;
        this.addFitness(ff, fitnessValue);
    }

    public void addFitness(FitnessFunction<T> ff, double fitnessValue) {
        this.addFitness(ff, fitnessValue, 0.0, 0);
    }

    public void addFitness(FitnessFunction<T> ff, double fitnessValue, double coverage) {
        this.addFitness(ff, fitnessValue, coverage, 0);
    }

    public void addFitness(FitnessFunction<T> ff, double fitnessValue, double coverage, int numCoveredGoals) {
        this.fitnessValues.put(ff, fitnessValue);
        this.previousFitnessValues.put(ff, fitnessValue);
        this.coverageValues.put(ff, coverage);
        this.numsCoveredGoals.put(ff, numCoveredGoals);
        this.numsNotCoveredGoals.put(ff, -1);
    }

    public void setFitness(FitnessFunction<T> ff, double value) throws IllegalArgumentException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw new IllegalArgumentException("Invalid value of Fitness: " + value + ", Fitness: " + ff.getClass().getName());
        }
        this.previousFitnessValues.put(ff, this.fitnessValues.getOrDefault(ff, value));
        this.fitnessValues.put(ff, value);
    }

    public boolean hasFitnessChanged() {
        return this.fitnessValues.keySet().stream().anyMatch(ff -> {
            double previousValue;
            double currentValue = this.fitnessValues.get(ff);
            return currentValue != (previousValue = this.previousFitnessValues.get(ff).doubleValue());
        });
    }

    @Override
    public abstract T clone();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    @Override
    public int compareTo(T c) {
        int i = (int)Math.signum(this.getFitness() - ((Chromosome)c).getFitness());
        if (i == 0) {
            return this.compareSecondaryObjective((Chromosome)c.self());
        }
        return i;
    }

    public abstract int compareSecondaryObjective(T var1);

    public abstract void mutate();

    public void crossOver(T other, int position) throws ConstructionFailedException {
        this.crossOver(other, position, position);
    }

    public abstract void crossOver(T var1, int var2, int var3) throws ConstructionFailedException;

    public abstract boolean localSearch(LocalSearchObjective<T> var1);

    public abstract int size();

    public boolean isChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
        this.localSearchApplied = false;
    }

    public boolean hasLocalSearchBeenApplied() {
        return this.localSearchApplied;
    }

    public void setLocalSearchApplied(boolean localSearchApplied) {
        this.localSearchApplied = localSearchApplied;
    }

    public double getCoverage() {
        double cov = this.coverageValues.values().stream().collect(Collectors.averagingDouble(Double::doubleValue));
        assert (cov >= 0.0 && cov <= 1.0) : "Incorrect coverage value " + cov + ". Expected value between 0 and 1";
        return cov;
    }

    public int getNumOfCoveredGoals() {
        return this.numsCoveredGoals.values().stream().mapToInt(Integer::intValue).sum();
    }

    public int getNumOfNotCoveredGoals() {
        return this.numsNotCoveredGoals.values().stream().mapToInt(Integer::intValue).sum();
    }

    public void setNumsOfCoveredGoals(Map<FitnessFunction<T>, Integer> fits) {
        this.numsCoveredGoals.clear();
        this.numsCoveredGoals.putAll(fits);
    }

    public void setNumsOfNotCoveredGoals(Map<FitnessFunction<T>, Integer> fits) {
        this.numsNotCoveredGoals.clear();
        this.numsNotCoveredGoals.putAll(fits);
    }

    public void setNumOfNotCoveredGoals(FitnessFunction<T> ff, int numCoveredGoals) {
        this.numsNotCoveredGoals.put(ff, numCoveredGoals);
    }

    public Map<FitnessFunction<T>, Integer> getNumsOfCoveredGoals() {
        return this.numsCoveredGoals;
    }

    public LinkedHashMap<FitnessFunction<T>, Integer> getNumsNotCoveredGoals() {
        return this.numsNotCoveredGoals;
    }

    public Map<FitnessFunction<T>, Double> getCoverageValues() {
        return this.coverageValues;
    }

    public void setCoverageValues(Map<? extends FitnessFunction<T>, Double> coverages) {
        this.coverageValues.clear();
        this.coverageValues.putAll(coverages);
    }

    public double getCoverage(FitnessFunction<T> ff) {
        return this.coverageValues.getOrDefault(ff, 0.0);
    }

    public void setCoverage(FitnessFunction<T> ff, double coverage) {
        this.coverageValues.put(ff, coverage);
    }

    public int getNumOfCoveredGoals(FitnessFunction<?> ff) {
        return this.numsCoveredGoals.getOrDefault(ff, 0);
    }

    public int getNumOfNotCoveredGoals(FitnessFunction<?> ff) {
        return this.numsNotCoveredGoals.getOrDefault(ff, 0);
    }

    public void setNumOfCoveredGoals(FitnessFunction<T> ff, int numCoveredGoals) {
        this.numsCoveredGoals.put(ff, numCoveredGoals);
    }

    public void updateAge(int generation) {
        this.age = generation;
    }

    public int getAge() {
        return this.age;
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int r) {
        this.rank = r;
    }

    public double getDistance() {
        return this.distance;
    }

    public void setDistance(double d) {
        this.distance = d;
    }

    public double getFitnessInstanceOf(Class<?> clazz) {
        Optional<FitnessFunction> off = this.fitnessValues.keySet().stream().filter(clazz::isInstance).findFirst();
        return off.map(this.fitnessValues::get).orElse(0.0);
    }

    public double getCoverageInstanceOf(Class<?> clazz) {
        Optional<FitnessFunction> off = this.coverageValues.keySet().stream().filter(clazz::isInstance).findFirst();
        return off.map(this.coverageValues::get).orElse(0.0);
    }

    public void increaseNumberOfMutations() {
        ++this.numberOfMutations;
    }

    public int getNumberOfMutations() {
        return this.numberOfMutations;
    }

    public void setNumberOfMutations(int numberOfMutations) {
        this.numberOfMutations = numberOfMutations;
    }

    public void increaseNumberOfEvaluations() {
        ++this.numberOfEvaluations;
    }

    public int getNumberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    public void setNumberOfEvaluations(int numberOfEvaluations) {
        this.numberOfEvaluations = numberOfEvaluations;
    }

    public double getKineticEnergy() {
        return this.kineticEnergy;
    }

    public void setKineticEnergy(double kineticEnergy) {
        this.kineticEnergy = kineticEnergy;
    }

    public int getNumCollisions() {
        return this.numCollisions;
    }

    public void setNumCollisions(int numCollisions) {
        this.numCollisions = numCollisions;
    }

    public void resetNumCollisions() {
        this.numCollisions = 0;
    }

    public void increaseNumCollisionsByOne() {
        ++this.numCollisions;
    }
}

