/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.NeighborModels;

public class Neighbourhood<T extends Chromosome<T>>
implements NeighborModels<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int population_size;
    private int _L;
    private int _R;
    private int _N;
    private int _S;
    private int _W;
    private int _E;
    private int _NE;
    private int _NW;
    private int _SE;
    private int _SW;
    private int _NN;
    private int _SS;
    private int _EE;
    private int _WW;
    int[][] neighbour;
    int columns;
    private final List<T> chromosomes = new ArrayList<T>();

    public Neighbourhood(int populationSize) {
        this.population_size = populationSize;
        this.neighbour = new int[this.population_size][0];
        this.columns = (int)Math.sqrt(this.population_size);
        this.constructNeighbour();
    }

    public void constructNeighbour() {
        int i;
        for (i = 0; i < this.population_size; ++i) {
            this.neighbour[i] = new int[8];
        }
        for (i = 0; i < this.population_size; ++i) {
            if (i > this.columns - 1) {
                this.neighbour[i][NeighborModels.Positions.N.ordinal()] = i - this.columns;
            } else {
                int mod = this.population_size % this.columns;
                if (mod != 0) {
                    int thisPosition = (i - this.columns + this.population_size) % this.population_size;
                    this.neighbour[i][NeighborModels.Positions.N.ordinal()] = i == 0 ? this.population_size - mod : (mod > 1 ? (i >= mod ? thisPosition - mod : thisPosition + 1) : thisPosition - 1);
                } else {
                    this.neighbour[i][NeighborModels.Positions.N.ordinal()] = (i - this.columns + this.population_size) % this.population_size;
                }
            }
            int thisPosition = (i + this.columns) % this.population_size;
            this.neighbour[i][NeighborModels.Positions.S.ordinal()] = this.population_size % this.columns != 0 && i + this.columns >= this.population_size ? i % this.columns : thisPosition;
            this.neighbour[i][NeighborModels.Positions.E.ordinal()] = (i + 1) % this.columns == 0 ? i - (this.columns - 1) : (this.population_size % this.columns != 0 && i == this.population_size - 1 ? i % this.columns + 1 : i + 1);
            if (i % this.columns == 0) {
                int westPosition = i + (this.columns - 1);
                if (westPosition >= this.population_size) {
                    this.neighbour[i][NeighborModels.Positions.W.ordinal()] = this.neighbour[i][NeighborModels.Positions.E.ordinal()];
                    continue;
                }
                this.neighbour[i][NeighborModels.Positions.W.ordinal()] = westPosition;
                continue;
            }
            this.neighbour[i][NeighborModels.Positions.W.ordinal()] = i - 1;
        }
        for (i = 0; i < this.population_size; ++i) {
            this.neighbour[i][NeighborModels.Positions.NW.ordinal()] = this.neighbour[this.neighbour[i][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.W.ordinal()];
            this.neighbour[i][NeighborModels.Positions.SW.ordinal()] = this.neighbour[this.neighbour[i][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.W.ordinal()];
            this.neighbour[i][NeighborModels.Positions.NE.ordinal()] = this.neighbour[this.neighbour[i][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.E.ordinal()];
            this.neighbour[i][NeighborModels.Positions.SE.ordinal()] = this.neighbour[this.neighbour[i][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.E.ordinal()];
        }
    }

    @Override
    public List<T> ringTopology(List<T> collection, int position) {
        this._L = position - 1 < 0 ? collection.size() - 1 : position - 1;
        this._R = position + 1 > collection.size() - 1 ? 0 : position + 1;
        this.chromosomes.add(collection.get(this._L));
        this.chromosomes.add(collection.get(position));
        this.chromosomes.add(collection.get(this._R));
        return this.chromosomes;
    }

    @Override
    public List<T> linearFive(List<T> collection, int position) {
        this._N = this.neighbour[position][NeighborModels.Positions.N.ordinal()];
        this._S = this.neighbour[position][NeighborModels.Positions.S.ordinal()];
        this._E = this.neighbour[position][NeighborModels.Positions.E.ordinal()];
        this._W = this.neighbour[position][NeighborModels.Positions.W.ordinal()];
        this.chromosomes.add(collection.get(this._N));
        this.chromosomes.add(collection.get(this._S));
        this.chromosomes.add(collection.get(this._E));
        this.chromosomes.add(collection.get(this._W));
        this.chromosomes.add(collection.get(position));
        return this.chromosomes;
    }

    @Override
    public List<T> compactNine(List<T> collection, int position) {
        this._N = this.neighbour[position][NeighborModels.Positions.N.ordinal()];
        this._S = this.neighbour[position][NeighborModels.Positions.S.ordinal()];
        this._E = this.neighbour[position][NeighborModels.Positions.E.ordinal()];
        this._W = this.neighbour[position][NeighborModels.Positions.W.ordinal()];
        this._NW = this.neighbour[this.neighbour[position][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.W.ordinal()];
        this._SW = this.neighbour[this.neighbour[position][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.W.ordinal()];
        this._NE = this.neighbour[this.neighbour[position][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.E.ordinal()];
        this._SE = this.neighbour[this.neighbour[position][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.E.ordinal()];
        this.chromosomes.add(collection.get(this._N));
        this.chromosomes.add(collection.get(this._S));
        this.chromosomes.add(collection.get(this._E));
        this.chromosomes.add(collection.get(this._W));
        this.chromosomes.add(collection.get(this._NW));
        this.chromosomes.add(collection.get(this._SW));
        this.chromosomes.add(collection.get(this._NE));
        this.chromosomes.add(collection.get(this._SE));
        this.chromosomes.add(collection.get(position));
        return this.chromosomes;
    }

    @Override
    public List<T> CompactThirteen(List<T> collection, int position) {
        this._N = this.neighbour[position][NeighborModels.Positions.N.ordinal()];
        this._S = this.neighbour[position][NeighborModels.Positions.S.ordinal()];
        this._E = this.neighbour[position][NeighborModels.Positions.E.ordinal()];
        this._W = this.neighbour[position][NeighborModels.Positions.W.ordinal()];
        this._NW = this.neighbour[this.neighbour[position][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.W.ordinal()];
        this._SW = this.neighbour[this.neighbour[position][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.W.ordinal()];
        this._NE = this.neighbour[this.neighbour[position][NeighborModels.Positions.N.ordinal()]][NeighborModels.Positions.E.ordinal()];
        this._SE = this.neighbour[this.neighbour[position][NeighborModels.Positions.S.ordinal()]][NeighborModels.Positions.E.ordinal()];
        this._NN = this.neighbour[this._N][NeighborModels.Positions.N.ordinal()];
        this._SS = this.neighbour[this._S][NeighborModels.Positions.S.ordinal()];
        this._EE = this.neighbour[this._E][NeighborModels.Positions.E.ordinal()];
        this._WW = this.neighbour[this._W][NeighborModels.Positions.W.ordinal()];
        this.chromosomes.add(collection.get(this._N));
        this.chromosomes.add(collection.get(this._S));
        this.chromosomes.add(collection.get(this._E));
        this.chromosomes.add(collection.get(this._W));
        this.chromosomes.add(collection.get(this._NW));
        this.chromosomes.add(collection.get(this._SW));
        this.chromosomes.add(collection.get(this._NE));
        this.chromosomes.add(collection.get(this._SE));
        this.chromosomes.add(collection.get(this._NN));
        this.chromosomes.add(collection.get(this._SS));
        this.chromosomes.add(collection.get(this._EE));
        this.chromosomes.add(collection.get(this._WW));
        this.chromosomes.add(collection.get(position));
        return this.chromosomes;
    }

    public List<T> getNeighbors(List<T> current_pop, int chromosome) {
        switch (Properties.MODEL) {
            case ONE_DIMENSION: {
                return this.ringTopology(current_pop, chromosome);
            }
            case LINEAR_FIVE: {
                return this.linearFive(current_pop, chromosome);
            }
            case COMPACT_NINE: {
                return this.compactNine(current_pop, chromosome);
            }
            case COMPACT_THIRTEEN: {
                return this.CompactThirteen(current_pop, chromosome);
            }
        }
        return this.linearFive(current_pop, chromosome);
    }
}

