/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga;

import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TournamentChromosomeFactory<T extends Chromosome<T>>
implements ChromosomeFactory<T> {
    private static final long serialVersionUID = -2493386206236363431L;
    private static final Logger logger = LoggerFactory.getLogger(TournamentChromosomeFactory.class);
    private final FitnessFunction<T> fitnessFunction;
    private final ChromosomeFactory<T> factory;
    private final int tournamentSize = 10;

    public TournamentChromosomeFactory(FitnessFunction<T> fitness, ChromosomeFactory<T> factory) {
        this.fitnessFunction = fitness;
        this.factory = factory;
    }

    @Override
    public T getChromosome() {
        Chromosome bestIndividual = null;
        logger.debug("Starting random generation");
        for (int i = 0; i < 10; ++i) {
            Chromosome candidate = this.factory.getChromosome();
            this.fitnessFunction.getFitness(candidate);
            if (bestIndividual == null) {
                bestIndividual = candidate;
                continue;
            }
            if (candidate.compareTo((Chromosome)bestIndividual) > 0) continue;
            logger.debug("Old individual has fitness " + bestIndividual.getFitness(this.fitnessFunction) + ", replacing with fitness " + candidate.getFitness(this.fitnessFunction));
            bestIndividual = candidate;
        }
        if (bestIndividual != null) {
            logger.debug("Resulting fitness: " + bestIndividual.getFitness(this.fitnessFunction));
        }
        assert (bestIndividual != null);
        return (T)bestIndividual;
    }
}

