/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.archive;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.archive.ArchiveUtils;
import org.evosuite.ga.archive.CoverageArchive;
import org.evosuite.ga.archive.MIOArchive;
import org.evosuite.runtime.util.AtMostOnceLogger;
import org.evosuite.setup.TestCluster;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.reflection.PrivateFieldStatement;
import org.evosuite.testcase.statements.reflection.PrivateMethodStatement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Archive
implements Serializable {
    private static final long serialVersionUID = 2604119519478973245L;
    private static final Logger logger = LoggerFactory.getLogger(Archive.class);
    protected final Map<String, Set<TestFitnessFunction>> nonCoveredTargetsOfEachMethod = new LinkedHashMap<String, Set<TestFitnessFunction>>();
    protected boolean hasBeenUpdated = false;

    public void addTarget(TestFitnessFunction target) {
        assert (target != null);
        if (!ArchiveUtils.isCriterionEnabled(target)) {
            throw new RuntimeException("Trying to add a target of '" + target.getClass().getSimpleName() + "' type to the archive, but correspondent criterion is not enabled.");
        }
    }

    public void addTargets(Collection<TestFitnessFunction> targets) {
        targets.forEach(this::addTarget);
    }

    protected void registerNonCoveredTargetOfAMethod(TestFitnessFunction target) {
        String targetMethod = this.getMethodFullName(target);
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(targetMethod)) {
            this.nonCoveredTargetsOfEachMethod.put(targetMethod, new LinkedHashSet());
        }
        this.nonCoveredTargetsOfEachMethod.get(targetMethod).add(target);
    }

    protected void removeNonCoveredTargetOfAMethod(TestFitnessFunction target) {
        String targetMethod = this.getMethodFullName(target);
        if (this.nonCoveredTargetsOfEachMethod.containsKey(targetMethod)) {
            this.nonCoveredTargetsOfEachMethod.get(targetMethod).remove(target);
            if (this.nonCoveredTargetsOfEachMethod.get(targetMethod).isEmpty()) {
                this.nonCoveredTargetsOfEachMethod.remove(targetMethod);
                this.ignoreMethodCall(this.getClassName(target), this.getMethodName(target));
            }
        }
    }

    public void updateArchive(TestFitnessFunction target, TestChromosome solution, double fitnessValue) {
        assert (target != null);
        assert (solution != null);
        assert (fitnessValue >= 0.0);
        if (!ArchiveUtils.isCriterionEnabled(target)) {
            throw new RuntimeException("Trying to update the archive with a target of '" + target.getClass().getSimpleName() + "' type, but correspondent criterion is not enabled.");
        }
    }

    public boolean isBetterThanCurrent(TestChromosome currentSolution, TestChromosome candidateSolution) {
        ExecutionResult currentSolutionExecution = currentSolution.getLastExecutionResult();
        ExecutionResult candidateSolutionExecution = candidateSolution.getLastExecutionResult();
        if (currentSolutionExecution != null && (currentSolutionExecution.hasTimeout() || currentSolutionExecution.hasTestException()) && candidateSolutionExecution != null && !candidateSolutionExecution.hasTimeout() && !candidateSolutionExecution.hasTestException()) {
            return true;
        }
        int penaltyCurrentSolution = this.calculatePenalty(currentSolution.getTestCase());
        int penaltyCandidateSolution = this.calculatePenalty(candidateSolution.getTestCase());
        if (penaltyCandidateSolution < penaltyCurrentSolution) {
            return true;
        }
        if (penaltyCandidateSolution > penaltyCurrentSolution) {
            return false;
        }
        assert (penaltyCandidateSolution == penaltyCurrentSolution);
        int timesBetter = 0;
        for (SecondaryObjective<TestChromosome> obj : TestChromosome.getSecondaryObjectives()) {
            if (obj.compareChromosomes(candidateSolution, currentSolution) < 0) {
                ++timesBetter;
                continue;
            }
            --timesBetter;
        }
        return timesBetter > 0;
    }

    public abstract boolean isArchiveEmpty();

    public abstract int getNumberOfTargets();

    public abstract int getNumberOfCoveredTargets();

    public abstract int getNumberOfCoveredTargets(Class<?> var1);

    public abstract Set<TestFitnessFunction> getCoveredTargets();

    public abstract int getNumberOfUncoveredTargets();

    public abstract int getNumberOfUncoveredTargets(Class<?> var1);

    public abstract Set<TestFitnessFunction> getUncoveredTargets();

    public abstract boolean hasTarget(TestFitnessFunction var1);

    public abstract int getNumberOfSolutions();

    public abstract Set<TestChromosome> getSolutions();

    public abstract TestChromosome getSolution();

    public abstract TestChromosome getSolution(TestFitnessFunction var1);

    public abstract boolean hasSolution(TestFitnessFunction var1);

    public abstract TestChromosome getRandomSolution();

    protected TestChromosome createMergedSolution(TestChromosome solution) {
        return solution;
    }

    protected abstract TestSuiteChromosome createMergedSolution(TestSuiteChromosome var1);

    public <C extends Chromosome<C>> C mergeArchiveAndSolution(C solution) {
        if (solution instanceof TestChromosome) {
            return (C)this.createMergedSolution((TestChromosome)solution);
        }
        if (solution instanceof TestSuiteChromosome) {
            return (C)this.createMergedSolution((TestSuiteChromosome)solution);
        }
        AtMostOnceLogger.warn(logger, "Type of solution '" + solution.getClass().getCanonicalName() + "' not supported");
        return null;
    }

    public abstract void shrinkSolutions(int var1);

    protected void ignoreMethodCall(String className, String methodName) {
        TestCluster cluster = TestCluster.getInstance();
        List<GenericAccessibleObject<?>> calls = cluster.getTestCalls();
        for (GenericAccessibleObject<?> call : calls) {
            String desc;
            if (!call.getDeclaringClass().getName().equals(className)) continue;
            if (call instanceof GenericMethod) {
                GenericMethod genericMethod = (GenericMethod)call;
                if (!methodName.startsWith(genericMethod.getName())) continue;
                desc = Type.getMethodDescriptor(genericMethod.getMethod());
                if (!(genericMethod.getName() + desc).equals(methodName)) continue;
                logger.info("Removing method " + methodName + " from cluster");
                cluster.removeTestCall(call);
                logger.info("Testcalls left: " + cluster.getNumTestCalls());
                continue;
            }
            if (!(call instanceof GenericConstructor)) continue;
            GenericConstructor genericConstructor = (GenericConstructor)call;
            if (!methodName.startsWith("<init>")) continue;
            desc = Type.getConstructorDescriptor(genericConstructor.getConstructor());
            if (!("<init>" + desc).equals(methodName)) continue;
            logger.info("Removing constructor " + methodName + " from cluster");
            cluster.removeTestCall(call);
            logger.info("Testcalls left: " + cluster.getNumTestCalls());
        }
    }

    protected int calculatePenalty(TestCase testCase) {
        int penalty = 0;
        if (this.hasFunctionalMocks(testCase)) {
            ++penalty;
        }
        if (this.hasFunctionalMocksForGenerableTypes(testCase)) {
            ++penalty;
        }
        if (this.hasPrivateAccess(testCase)) {
            ++penalty;
        }
        return penalty;
    }

    private boolean hasFunctionalMocks(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof FunctionalMockStatement)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFunctionalMocksForGenerableTypes(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof FunctionalMockStatement)) continue;
            FunctionalMockStatement fm = (FunctionalMockStatement)statement;
            Class<?> target = fm.getTargetClass();
            GenericClass gc = new GenericClass(target);
            if (!TestCluster.getInstance().hasGenerator(gc)) continue;
            return true;
        }
        return false;
    }

    private boolean hasPrivateAccess(TestCase testCase) {
        for (Statement statement : testCase) {
            if (!(statement instanceof PrivateFieldStatement) && !(statement instanceof PrivateMethodStatement)) continue;
            return true;
        }
        return false;
    }

    protected String getMethodFullName(TestFitnessFunction target) {
        return this.getClassName(target) + this.getMethodName(target);
    }

    private String getClassName(TestFitnessFunction target) {
        return target.getTargetClass();
    }

    private String getMethodName(TestFitnessFunction target) {
        return target.getTargetMethod();
    }

    protected boolean isMethodFullyCovered(String methodFullName) {
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(methodFullName)) {
            return true;
        }
        return this.nonCoveredTargetsOfEachMethod.get(methodFullName).isEmpty();
    }

    public int getNumOfRemainingTargets(String methodFullName) {
        if (!this.nonCoveredTargetsOfEachMethod.containsKey(methodFullName)) {
            return 0;
        }
        return this.nonCoveredTargetsOfEachMethod.get(methodFullName).size();
    }

    public abstract String toString();

    public void reset() {
        this.nonCoveredTargetsOfEachMethod.clear();
    }

    public boolean hasBeenUpdated() {
        return this.hasBeenUpdated;
    }

    public void setHasBeenUpdated(boolean b) {
        this.hasBeenUpdated = b;
    }

    public static Archive getArchiveInstance() {
        switch (Properties.ARCHIVE_TYPE) {
            default: {
                return CoverageArchive.instance;
            }
            case MIO: 
        }
        return MIOArchive.instance;
    }
}

