/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.comparators;

import java.io.Serializable;
import java.util.Comparator;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.FitnessFunction;

public class PreferenceSortingComparator<T extends Chromosome<T>>
implements Comparator<T>,
Serializable {
    private static final long serialVersionUID = 8939172959105413213L;
    private final FitnessFunction<T> objective;

    public PreferenceSortingComparator(FitnessFunction<T> goal) {
        this.objective = goal;
    }

    @Override
    public int compare(T solution1, T solution2) {
        double value2;
        if (solution1 == null) {
            return 1;
        }
        if (solution2 == null) {
            return -1;
        }
        double value1 = ((Chromosome)solution1).getFitness(this.objective);
        if (value1 < (value2 = ((Chromosome)solution2).getFitness(this.objective))) {
            return -1;
        }
        if (value1 > value2) {
            return 1;
        }
        return ((Chromosome)solution1).compareSecondaryObjective(solution2);
    }
}

