/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.localsearch.DefaultLocalSearchObjective;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.metaheuristics.SearchAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.ranking.RankBasedPreferenceSorting;
import org.evosuite.ga.operators.ranking.RankingFunction;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.populationlimit.IndividualPopulationLimit;
import org.evosuite.ga.populationlimit.PopulationLimit;
import org.evosuite.ga.stoppingconditions.MaxGenerationStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeneticAlgorithm<T extends Chromosome<T>>
implements SearchAlgorithm,
Serializable {
    private static final long serialVersionUID = 5155609385855093435L;
    private static final Logger logger = LoggerFactory.getLogger(GeneticAlgorithm.class);
    protected List<FitnessFunction<T>> fitnessFunctions = new ArrayList<FitnessFunction<T>>();
    protected SelectionFunction<T> selectionFunction = new RankSelection();
    protected CrossOverFunction<T> crossoverFunction = new SinglePointCrossOver();
    protected List<T> population = new ArrayList<T>();
    protected ChromosomeFactory<T> chromosomeFactory;
    protected transient Set<SearchListener<T>> listeners = new HashSet<SearchListener<T>>();
    protected transient Set<StoppingCondition<T>> stoppingConditions = new HashSet<StoppingCondition<T>>();
    protected Set<BloatControlFunction<T>> bloatControl = new HashSet<BloatControlFunction<T>>();
    protected LocalSearchObjective<T> localObjective = new DefaultLocalSearchObjective();
    protected PopulationLimit<T> populationLimit = new IndividualPopulationLimit();
    protected int currentIteration = 0;
    protected double localSearchProbability = Properties.LOCAL_SEARCH_PROBABILITY;
    protected RankingFunction<T> rankingFunction = new RankBasedPreferenceSorting();

    public GeneticAlgorithm(ChromosomeFactory<T> factory) {
        this.chromosomeFactory = factory;
        this.addStoppingCondition(new MaxGenerationStoppingCondition());
        if (Properties.LOCAL_SEARCH_RATE > 0) {
            this.addListener(LocalSearchBudget.getInstance());
        }
    }

    protected abstract void evolve();

    protected boolean shouldApplyLocalSearch() {
        if (Properties.LOCAL_SEARCH_RATE <= 0) {
            return false;
        }
        if (this.getAge() % Properties.LOCAL_SEARCH_RATE == 0) {
            return Randomness.nextDouble() <= this.localSearchProbability;
        }
        return false;
    }

    protected void disableFirstSecondaryCriterion() {
        if (TestSuiteChromosome.getSecondaryObjectivesSize() > 1) {
            TestSuiteChromosome.disableFirstSecondaryObjective();
            if (ArrayUtil.contains((Object[])Properties.SECONDARY_OBJECTIVE, (Object)Properties.SecondaryObjective.IBRANCH)) {
                ExecutionTracer.disableContext();
            }
            logger.info("second secondary criterion enabled");
        }
    }

    protected void enableFirstSecondaryCriterion() {
        if (TestSuiteChromosome.getSecondaryObjectivesSize() > 1) {
            TestSuiteChromosome.enableFirstSecondaryObjective();
            if (ArrayUtil.contains((Object[])Properties.SECONDARY_OBJECTIVE, (Object)Properties.SecondaryObjective.IBRANCH)) {
                ExecutionTracer.enableContext();
            }
            logger.info("first secondary criterion enabled");
        }
    }

    protected void updateSecondaryCriterion(int starvationCounter) {
        if (Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER > 0 && TestSuiteChromosome.getSecondaryObjectivesSize() > 1) {
            double progress = this.progress() * 100.0;
            if (progress > (double)Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER) {
                if (Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION) {
                    this.updateSecondaryObjectiveStarvation(starvationCounter);
                } else {
                    this.enableFirstSecondaryCriterion();
                    Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER = 0;
                }
            }
        } else if (Properties.ENABLE_SECONDARY_OBJECTIVE_STARVATION && Properties.ENABLE_SECONDARY_OBJECTIVE_AFTER == 0 && TestSuiteChromosome.getSecondaryObjectivesSize() > 1) {
            this.updateSecondaryObjectiveStarvation(starvationCounter);
        }
    }

    private void updateSecondaryObjectiveStarvation(int starvationCounter) {
        if (starvationCounter > Properties.STARVATION_AFTER_GENERATION && !TestSuiteChromosome.isFirstSecondaryObjectiveEnabled()) {
            this.enableFirstSecondaryCriterion();
        } else if (starvationCounter == 0 && TestSuiteChromosome.isFirstSecondaryObjectiveEnabled() && TestSuiteChromosome.getSecondaryObjectivesSize() > 1) {
            this.disableFirstSecondaryCriterion();
        }
    }

    protected void applyLocalSearch() {
        if (!this.shouldApplyLocalSearch()) {
            return;
        }
        logger.debug("Applying local search");
        LocalSearchBudget.getInstance().localSearchStarted();
        boolean improvement = false;
        for (Chromosome individual : this.population) {
            if (this.isFinished()) break;
            if (LocalSearchBudget.getInstance().isFinished()) {
                logger.debug("Local search budget used up, exiting local search");
                break;
            }
            if (!individual.localSearch(this.localObjective)) continue;
            improvement = true;
        }
        if (improvement) {
            DSEStats.getInstance().reportNewIncrease();
            this.updateProbability(true);
            logger.debug("Increasing probability of applying LS to " + this.localSearchProbability);
        } else {
            DSEStats.getInstance().reportNewDecrease();
            this.updateProbability(false);
            logger.debug("Decreasing probability of applying LS to " + this.localSearchProbability);
        }
        if (improvement && !this.populationIsSorted()) {
            this.sortPopulation();
        }
    }

    private boolean populationIsSorted() {
        Chromosome previous = null;
        for (Chromosome current : this.population) {
            if (previous != null && !this.isBetterOrEqual(previous, current)) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    protected boolean isMaximizationFunction() {
        return this.getFitnessFunction().isMaximizationFunction();
    }

    protected void updateProbability(boolean improvement) {
        if (improvement) {
            this.localSearchProbability *= Properties.LOCAL_SEARCH_ADAPTATION_RATE;
            this.localSearchProbability = Math.min(this.localSearchProbability, 1.0);
        } else {
            this.localSearchProbability /= Properties.LOCAL_SEARCH_ADAPTATION_RATE;
            this.localSearchProbability = Math.max(this.localSearchProbability, Double.MIN_VALUE);
        }
    }

    public abstract void initializePopulation();

    @Override
    public abstract void generateSolution();

    protected void generateInitialPopulation(int population_size) {
        this.generateRandomPopulation(population_size - this.population.size());
    }

    protected void starveToLimit(int limit) {
        if (Properties.STARVE_BY_FITNESS) {
            this.starveByFitness(limit);
        } else {
            this.starveRandomly(limit);
        }
    }

    protected void starveRandomly(int limit) {
        while (this.population.size() > limit) {
            int removePos = Randomness.nextInt() % this.population.size();
            this.population.remove(removePos);
        }
    }

    protected void starveByFitness(int limit) {
        this.calculateFitnessAndSortPopulation();
        if (this.population.size() > limit) {
            this.population.subList(limit, this.population.size()).clear();
        }
    }

    protected void generateRandomPopulation(int population_size) {
        this.population.addAll(this.getRandomPopulation(population_size));
    }

    protected List<T> getRandomPopulation(int population_size) {
        logger.debug("Creating random population");
        ArrayList<T> newPopulation = new ArrayList<T>(population_size);
        for (int i = 0; i < population_size; ++i) {
            T individual = this.chromosomeFactory.getChromosome();
            this.fitnessFunctions.forEach(arg_0 -> individual.addFitness(arg_0));
            newPopulation.add(individual);
            if (this.isFinished()) break;
        }
        logger.debug("Created " + newPopulation.size() + " individuals");
        return newPopulation;
    }

    public void clearPopulation() {
        logger.debug("Resetting population");
        this.population.clear();
    }

    public void addFitnessFunction(FitnessFunction<T> function) {
        this.fitnessFunctions.add(function);
        this.localObjective.addFitnessFunction(function);
    }

    public void addFitnessFunctions(Collection<? extends FitnessFunction<T>> functions) {
        functions.forEach(this::addFitnessFunction);
    }

    public FitnessFunction<T> getFitnessFunction() {
        return this.fitnessFunctions.get(0);
    }

    public List<? extends FitnessFunction<T>> getFitnessFunctions() {
        return this.fitnessFunctions;
    }

    public int getNumberOfFitnessFunctions() {
        return this.fitnessFunctions.size();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        int i = 0;
        for (Chromosome c : this.population) {
            str.append("\n  - test ").append(i);
            for (FitnessFunction<T> ff : this.fitnessFunctions) {
                DecimalFormat df = new DecimalFormat("#.#####");
                str.append(", ").append(ff.getClass().getSimpleName().replace("CoverageSuiteFitness", "")).append(" ").append(df.format(c.getFitness(ff)));
            }
            ++i;
        }
        return str.toString();
    }

    public void setSelectionFunction(SelectionFunction<T> function) {
        this.selectionFunction = function;
    }

    public SelectionFunction<T> getSelectionFunction() {
        return this.selectionFunction;
    }

    public void setRankingFunction(RankingFunction<T> function) {
        this.rankingFunction = function;
    }

    public RankingFunction<T> getRankingFunction() {
        return this.rankingFunction;
    }

    public void setBloatControl(BloatControlFunction<T> bloat_control) {
        this.bloatControl.clear();
        this.addBloatControl(bloat_control);
    }

    public void addBloatControl(BloatControlFunction<T> bloat_control) {
        this.bloatControl.add(bloat_control);
    }

    public boolean isTooLong(T chromosome) {
        return this.bloatControl.stream().anyMatch(b -> b.isTooLong(chromosome));
    }

    public int getAge() {
        return this.currentIteration;
    }

    protected void calculateFitness() {
        logger.debug("Calculating fitness for " + this.population.size() + " individuals");
        for (Chromosome c : this.population) {
            if (this.isFinished()) break;
            this.calculateFitness(c);
        }
    }

    protected void calculateFitness(T c) {
        this.fitnessFunctions.forEach(ff -> {
            ff.getFitness(c);
            this.notifyEvaluation(c);
        });
    }

    protected void calculateFitnessAndSortPopulation() {
        this.calculateFitness();
        this.sortPopulation();
    }

    public int getPopulationSize() {
        return this.population.size();
    }

    protected List<T> elitism() {
        logger.debug("Elitism with ELITE = " + Properties.ELITE);
        List elite = this.population.stream().limit(Properties.ELITE).peek(c -> logger.trace("Copying individual with fitness " + c.getFitness())).map(Chromosome::clone).collect(Collectors.toList());
        logger.trace("Done.");
        return elite;
    }

    protected List<T> randomism() {
        logger.debug("Randomism");
        return Stream.generate(this.chromosomeFactory::getChromosome).limit(Properties.ELITE).collect(Collectors.toList());
    }

    public void updateFitnessFunctionsAndValues() {
        this.fitnessFunctions.forEach(FitnessFunction::updateCoveredGoals);
        if (!Archive.getArchiveInstance().hasBeenUpdated()) {
            return;
        }
        this.population.forEach(t -> this.fitnessFunctions.forEach(ff -> ff.getFitness(t)));
        Archive.getArchiveInstance().setHasBeenUpdated(false);
    }

    public T getBestIndividual() {
        if (this.population.isEmpty()) {
            return this.chromosomeFactory.getChromosome();
        }
        return (T)((Chromosome)this.population.get(0));
    }

    public List<T> getBestIndividuals() {
        ArrayList<T> bestIndividuals = new ArrayList<T>();
        if (this.population.isEmpty()) {
            bestIndividuals.add(this.chromosomeFactory.getChromosome());
            return bestIndividuals;
        }
        if (Properties.ALGORITHM == Properties.Algorithm.NSGAII || Properties.ALGORITHM == Properties.Algorithm.SPEA2) {
            return this.population;
        }
        bestIndividuals.add(this.population.get(0));
        return bestIndividuals;
    }

    public void writeIndividuals(List<T> individuals) {
        if (!Properties.WRITE_INDIVIDUALS) {
            return;
        }
        File dir = new File(Properties.REPORT_DIR);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create report dir: " + Properties.REPORT_DIR);
        }
        try {
            File populationFile = new File(Properties.REPORT_DIR + File.separator + "pareto_" + this.currentIteration + ".csv");
            boolean newFile = populationFile.createNewFile();
            if (!newFile) {
                logger.warn("File already exists, it is overwritten: " + populationFile.getName());
            }
            FileWriter fw = new FileWriter(populationFile.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            PrintWriter out = new PrintWriter(bw);
            String header = this.fitnessFunctions.stream().map(ff -> ff.getClass().getSimpleName()).collect(Collectors.joining(","));
            if (Properties.ALGORITHM == Properties.Algorithm.NSGAII) {
                out.println("rank," + header);
            } else if (Properties.ALGORITHM == Properties.Algorithm.SPEA2) {
                out.println("strength," + header);
            }
            for (Chromosome t : individuals) {
                String content = this.fitnessFunctions.stream().map(ff -> Double.toString(t.getFitness(ff))).collect(Collectors.joining(","));
                if (Properties.ALGORITHM == Properties.Algorithm.NSGAII) {
                    out.println(t.getRank() + "," + content);
                    continue;
                }
                if (Properties.ALGORITHM != Properties.Algorithm.SPEA2) continue;
                out.println(t.getDistance() + "," + content);
            }
            out.close();
            bw.close();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setChromosomeFactory(ChromosomeFactory<T> factory) {
        this.chromosomeFactory = factory;
    }

    public void setCrossOverFunction(CrossOverFunction<T> crossover) {
        this.crossoverFunction = crossover;
    }

    public void addListener(SearchListener<T> listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SearchListener<T> listener) {
        this.listeners.remove(listener);
    }

    protected void notifySearchStarted() {
        this.listeners.forEach(l -> l.searchStarted(this));
    }

    protected void notifySearchFinished() {
        this.listeners.forEach(l -> l.searchFinished(this));
    }

    protected void notifyIteration() {
        this.listeners.forEach(l -> l.iteration(this));
    }

    protected void notifyEvaluation(T chromosome) {
        this.listeners.forEach(l -> l.fitnessEvaluation(chromosome));
    }

    protected void notifyMutation(T chromosome) {
        this.listeners.forEach(l -> l.modification(chromosome));
    }

    protected void sortPopulation() {
        if (Properties.SHUFFLE_GOALS) {
            Randomness.shuffle(this.population);
        }
        if (this.isMaximizationFunction()) {
            this.population.sort(Collections.reverseOrder());
        } else {
            Collections.sort(this.population);
        }
    }

    public List<T> getPopulation() {
        return Collections.unmodifiableList(this.population);
    }

    public boolean isNextPopulationFull(List<T> nextGeneration) {
        return this.populationLimit.isPopulationFull(nextGeneration);
    }

    public void setPopulationLimit(PopulationLimit<T> limit) {
        this.populationLimit = limit;
    }

    public boolean isFinished() {
        return this.stoppingConditions.stream().anyMatch(StoppingCondition::isFinished);
    }

    public void addStoppingCondition(StoppingCondition<T> condition) {
        boolean contained = this.stoppingConditions.stream().anyMatch(obj -> obj.getClass().equals(condition.getClass()));
        if (contained) {
            return;
        }
        logger.debug("Adding new stopping condition");
        this.stoppingConditions.add(condition);
        this.addListener(condition);
    }

    public Set<StoppingCondition<T>> getStoppingConditions() {
        return this.stoppingConditions;
    }

    public void setStoppingCondition(StoppingCondition<T> condition) {
        this.stoppingConditions.clear();
        logger.debug("Setting stopping condition");
        this.stoppingConditions.add(condition);
        this.addListener(condition);
    }

    public void removeStoppingCondition(StoppingCondition<T> condition) {
        boolean removed = this.stoppingConditions.removeIf(sc -> sc.getClass().equals(condition.getClass()));
        if (removed) {
            this.removeListener(condition);
        }
    }

    public void resetStoppingConditions() {
        this.stoppingConditions.forEach(StoppingCondition::reset);
    }

    public void setStoppingConditionLimit(int value) {
        this.stoppingConditions.forEach(c -> c.setLimit(value));
    }

    protected void updateBestIndividualFromArchive() {
        if (!Properties.TEST_ARCHIVE) {
            return;
        }
        T best = Archive.getArchiveInstance().mergeArchiveAndSolution(this.getBestIndividual());
        ((Chromosome)best).getCoverageValues().keySet().removeIf(ff -> !this.fitnessFunctions.contains(ff));
        this.population.add(0, best);
    }

    protected boolean isBetterOrEqual(T chromosome1, T chromosome2) {
        if (this.getFitnessFunction().isMaximizationFunction()) {
            return ((Chromosome)chromosome1).compareTo(chromosome2) >= 0;
        }
        return ((Chromosome)chromosome1).compareTo(chromosome2) <= 0;
    }

    public void printBudget() {
        Logger logger = LoggingUtils.getEvoLogger();
        logger.info("* GA-Budget:");
        this.stoppingConditions.stream().map(sc -> "\t- " + sc.toString()).forEach(logger::info);
    }

    public String getBudgetString() {
        return this.stoppingConditions.stream().map(Object::toString).collect(Collectors.joining(" "));
    }

    protected double progress() {
        long totalbudget = 0L;
        long currentbudget = 0L;
        for (StoppingCondition<T> sc : this.stoppingConditions) {
            if (sc.getLimit() == 0L) continue;
            totalbudget += sc.getLimit();
            currentbudget += sc.getCurrentValue();
        }
        return (double)currentbudget / (double)totalbudget;
    }
}

