/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.evosuite.ga.archive.Archive;
import org.evosuite.ga.metaheuristics.MIO;
import org.evosuite.ga.metaheuristics.mosa.AbstractMOSA;
import org.evosuite.ga.metaheuristics.mosa.MOSATestSuiteAdapter;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class MIOTestSuiteAdapter
extends MOSATestSuiteAdapter {
    private static final long serialVersionUID = 3297246957849185819L;

    public MIOTestSuiteAdapter(MIO algorithm) {
        super(algorithm);
    }

    @Override
    public List<TestSuiteChromosome> getBestIndividuals() {
        TestSuiteChromosome bestTestCases = new TestSuiteChromosome();
        Set<TestChromosome> solutions = Archive.getArchiveInstance().getSolutions();
        bestTestCases.addTests(solutions);
        this.computeCoverageAndFitness(bestTestCases);
        ArrayList<TestSuiteChromosome> bests = new ArrayList<TestSuiteChromosome>(1);
        bests.add(bestTestCases);
        return bests;
    }

    @Override
    public TestSuiteChromosome getBestIndividual() {
        TestSuiteChromosome best = new TestSuiteChromosome();
        Set<TestChromosome> solutions = Archive.getArchiveInstance().getSolutions();
        best.addTests(solutions);
        if (solutions.isEmpty()) {
            Set<TestSuiteFitnessFunction> ffs = ((AbstractMOSA)this.getAlgorithm()).suiteFitnessFunctions.keySet();
            for (TestSuiteFitnessFunction suiteFitness : ffs) {
                best.setCoverage(suiteFitness, 0.0);
                best.setFitness(suiteFitness, 1.0);
            }
            return best;
        }
        this.computeCoverageAndFitness(best);
        return best;
    }
}

