/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.NoveltyFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoveltySearch
extends GeneticAlgorithm<TestChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(NoveltySearch.class);
    private static final long serialVersionUID = -1047550745990198972L;
    private NoveltyFunction<TestChromosome> noveltyFunction = null;

    public NoveltySearch(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
    }

    public void setNoveltyFunction(NoveltyFunction<TestChromosome> function) {
        this.noveltyFunction = function;
    }

    protected void sortPopulation(List<TestChromosome> population, Map<TestChromosome, Double> noveltyMap) {
        population.sort(Collections.reverseOrder(Comparator.comparingDouble(noveltyMap::get)));
    }

    protected void calculateNoveltyAndSortPopulation() {
        logger.debug("Calculating novelty for " + this.population.size() + " individuals");
        Iterator iterator = this.population.iterator();
        LinkedHashMap<TestChromosome, Double> noveltyMap = new LinkedHashMap<TestChromosome, Double>();
        while (iterator.hasNext()) {
            TestChromosome c = (TestChromosome)iterator.next();
            if (this.isFinished()) {
                if (!c.isChanged()) continue;
                iterator.remove();
                continue;
            }
            double novelty = this.noveltyFunction.getNovelty(c, this.population);
            noveltyMap.put(c, novelty);
        }
        this.sortPopulation(this.population, noveltyMap);
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        this.generateInitialPopulation(Properties.POPULATION);
        this.calculateNoveltyAndSortPopulation();
        this.notifyIteration();
    }

    @Override
    protected void evolve() {
        ArrayList<TestChromosome> newGeneration = new ArrayList<TestChromosome>();
        while (!this.isNextPopulationFull(newGeneration)) {
            TestChromosome offspring2;
            TestChromosome offspring1;
            TestChromosome parent2;
            TestChromosome parent1;
            block8: {
                parent1 = (TestChromosome)this.selectionFunction.select(this.population);
                parent2 = (TestChromosome)this.selectionFunction.select(this.population);
                offspring1 = parent1.clone();
                offspring2 = parent2.clone();
                try {
                    if (Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                        this.crossoverFunction.crossOver(offspring1, offspring2);
                    }
                    this.notifyMutation(offspring1);
                    offspring1.mutate();
                    this.notifyMutation(offspring2);
                    offspring2.mutate();
                    if (offspring1.isChanged()) {
                        offspring1.updateAge(this.currentIteration);
                    }
                    if (!offspring2.isChanged()) break block8;
                    offspring2.updateAge(this.currentIteration);
                }
                catch (ConstructionFailedException e) {
                    logger.info("CrossOver/Mutation failed.");
                    continue;
                }
            }
            if (!this.isTooLong(offspring1)) {
                newGeneration.add(offspring1);
            } else {
                newGeneration.add(parent1);
            }
            if (!this.isTooLong(offspring2)) {
                newGeneration.add(offspring2);
                continue;
            }
            newGeneration.add(parent2);
        }
        this.population = newGeneration;
        this.updateFitnessFunctionsAndValues();
        ++this.currentIteration;
    }

    @Override
    public void generateSolution() {
        if (this.population.isEmpty()) {
            this.initializePopulation();
        }
        logger.warn("Starting evolution of novelty search algorithm");
        while (!this.isFinished()) {
            logger.warn("Current population: " + this.getAge() + "/" + Properties.SEARCH_BUDGET);
            this.evolve();
            this.calculateNoveltyAndSortPopulation();
            this.notifyIteration();
        }
        this.updateBestIndividualFromArchive();
        this.notifySearchFinished();
    }
}

