/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.ProgressMonitor;
import org.evosuite.ShutdownTestWriter;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.TestSuiteChromosomeFactoryMock;
import org.evosuite.ga.TestSuiteFitnessFunctionMock;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.bloatcontrol.MaxSizeBloatControl;
import org.evosuite.ga.metaheuristics.AdapteeListener;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.operators.crossover.CoverageCrossOver;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointFixedCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointRelativeCrossOver;
import org.evosuite.ga.operators.crossover.UniformCrossOver;
import org.evosuite.ga.operators.ranking.FastNonDominatedSorting;
import org.evosuite.ga.operators.ranking.RankBasedPreferenceSorting;
import org.evosuite.ga.operators.ranking.RankingFunction;
import org.evosuite.ga.operators.selection.BestKSelection;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.FitnessProportionateSelection;
import org.evosuite.ga.operators.selection.RandomKSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.operators.selection.TournamentSelection;
import org.evosuite.ga.operators.selection.TournamentSelectionRankAndCrowdingDistanceComparator;
import org.evosuite.ga.populationlimit.IndividualPopulationLimit;
import org.evosuite.ga.populationlimit.PopulationLimit;
import org.evosuite.ga.populationlimit.SizePopulationLimit;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxGenerationStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.RMIStoppingCondition;
import org.evosuite.ga.stoppingconditions.SocketStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.statistics.StatisticsListener;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.RelativeSuiteLengthBloatControl;
import org.evosuite.testsuite.StatementsPopulationLimit;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.utils.ResourceController;

public abstract class TestSuiteAdapter<A extends GeneticAlgorithm<TestChromosome>>
extends GeneticAlgorithm<TestSuiteChromosome> {
    private static final long serialVersionUID = -506409298544885038L;
    private final IdentityHashMap<SearchListener<TestSuiteChromosome>, SearchListener<TestChromosome>> searchListenerMapping = new IdentityHashMap();
    private final A algorithm;

    protected TestSuiteAdapter(A algorithm) {
        super(null);
        this.algorithm = (GeneticAlgorithm)Objects.requireNonNull(algorithm);
        ((GeneticAlgorithm)algorithm).addListener(new AdapteeListener(this));
        this.clear();
    }

    private void clear() {
        this.population = null;
        this.fitnessFunctions = null;
        this.selectionFunction = null;
        this.crossoverFunction = null;
        this.chromosomeFactory = null;
        this.bloatControl = null;
        this.localObjective = null;
        this.populationLimit = null;
        this.rankingFunction = null;
        this.currentIteration = Integer.MIN_VALUE;
        this.localSearchProbability = Double.NaN;
    }

    protected A getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public abstract TestSuiteChromosome getBestIndividual();

    @Override
    public abstract List<TestSuiteChromosome> getBestIndividuals();

    @Override
    protected final void evolve() {
        ((GeneticAlgorithm)this.algorithm).evolve();
    }

    @Override
    public final void initializePopulation() {
        ((GeneticAlgorithm)this.algorithm).initializePopulation();
    }

    @Override
    public void generateSolution() {
        ((GeneticAlgorithm)this.algorithm).generateSolution();
    }

    @Override
    public int getAge() {
        return ((GeneticAlgorithm)this.algorithm).getAge();
    }

    @Override
    protected final void notifyMutation(TestSuiteChromosome chromosome) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The adaptee should notify about mutations");
    }

    @Override
    protected final void notifyEvaluation(TestSuiteChromosome chromosome) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The adaptee should notify about evaluations");
    }

    @Override
    protected final boolean shouldApplyLocalSearch() {
        return ((GeneticAlgorithm)this.algorithm).shouldApplyLocalSearch();
    }

    @Override
    protected final void disableFirstSecondaryCriterion() {
        ((GeneticAlgorithm)this.algorithm).disableFirstSecondaryCriterion();
    }

    @Override
    protected final void enableFirstSecondaryCriterion() {
        ((GeneticAlgorithm)this.algorithm).enableFirstSecondaryCriterion();
    }

    @Override
    protected final void updateSecondaryCriterion(int starvationCounter) {
        ((GeneticAlgorithm)this.algorithm).updateSecondaryCriterion(starvationCounter);
    }

    @Override
    protected final void applyLocalSearch() {
        ((GeneticAlgorithm)this.algorithm).applyLocalSearch();
    }

    @Override
    protected final void updateProbability(boolean improvement) {
        ((GeneticAlgorithm)this.algorithm).updateProbability(improvement);
    }

    @Override
    protected final void generateInitialPopulation(int populationSize) {
        ((GeneticAlgorithm)this.algorithm).generateInitialPopulation(populationSize);
    }

    @Override
    protected final void starveToLimit(int limit) {
        ((GeneticAlgorithm)this.algorithm).starveToLimit(limit);
    }

    @Override
    protected final void starveRandomly(int limit) {
        ((GeneticAlgorithm)this.algorithm).starveRandomly(limit);
    }

    @Override
    protected final void starveByFitness(int limit) {
        ((GeneticAlgorithm)this.algorithm).starveByFitness(limit);
    }

    @Override
    protected final void generateRandomPopulation(int populationSize) {
        ((GeneticAlgorithm)this.algorithm).generateRandomPopulation(populationSize);
    }

    @Override
    public final void clearPopulation() {
        ((GeneticAlgorithm)this.algorithm).clearPopulation();
    }

    @Override
    public void addFitnessFunction(FitnessFunction<TestSuiteChromosome> function) {
        ((GeneticAlgorithm)this.algorithm).addFitnessFunction(TestSuiteAdapter.mapFitnessFunctionToTestCaseLevel(function));
    }

    @Override
    public final FitnessFunction<TestSuiteChromosome> getFitnessFunction() {
        return new TestSuiteFitnessFunctionWrapper(((GeneticAlgorithm)this.algorithm).getFitnessFunction());
    }

    @Override
    public final int getNumberOfFitnessFunctions() {
        return ((GeneticAlgorithm)this.algorithm).getNumberOfFitnessFunctions();
    }

    @Override
    public final SelectionFunction<TestSuiteChromosome> getSelectionFunction() {
        return TestSuiteAdapter.mapSelectionFunction(((GeneticAlgorithm)this.algorithm).getSelectionFunction());
    }

    @Override
    public void setSelectionFunction(SelectionFunction<TestSuiteChromosome> function) throws IllegalArgumentException {
        SelectionFunction adapteeFunction = TestSuiteAdapter.mapSelectionFunction(function);
        adapteeFunction.setMaximize(function.isMaximize());
        ((GeneticAlgorithm)this.algorithm).setSelectionFunction(adapteeFunction);
    }

    private static <T extends Chromosome<T>, X extends Chromosome<X>> SelectionFunction<T> mapSelectionFunction(SelectionFunction<X> function) {
        if (function instanceof FitnessProportionateSelection) {
            return new FitnessProportionateSelection((FitnessProportionateSelection)function);
        }
        if (function instanceof TournamentSelection) {
            return new TournamentSelection((TournamentSelection)function);
        }
        if (function instanceof BinaryTournamentSelectionCrowdedComparison) {
            return new BinaryTournamentSelectionCrowdedComparison((BinaryTournamentSelectionCrowdedComparison)function);
        }
        if (function instanceof TournamentSelectionRankAndCrowdingDistanceComparator) {
            return new TournamentSelectionRankAndCrowdingDistanceComparator((TournamentSelectionRankAndCrowdingDistanceComparator)function);
        }
        if (function instanceof BestKSelection) {
            return new BestKSelection((BestKSelection)function);
        }
        if (function instanceof RandomKSelection) {
            return new RandomKSelection((RandomKSelection)function);
        }
        if (function instanceof RankSelection) {
            return new RankSelection((RankSelection)function);
        }
        throw new IllegalArgumentException("cannot adapt selection function " + function);
    }

    @Override
    public final RankingFunction<TestSuiteChromosome> getRankingFunction() {
        return TestSuiteAdapter.mapRankingFunction(((GeneticAlgorithm)this.algorithm).getRankingFunction());
    }

    @Override
    public void setRankingFunction(RankingFunction<TestSuiteChromosome> function) {
        RankingFunction adapteeFunction = TestSuiteAdapter.mapRankingFunction(function);
        ((GeneticAlgorithm)this.algorithm).setRankingFunction(adapteeFunction);
    }

    private static <T extends Chromosome<T>, X extends Chromosome<X>> RankingFunction<T> mapRankingFunction(RankingFunction<X> function) {
        if (function instanceof FastNonDominatedSorting) {
            return new FastNonDominatedSorting();
        }
        if (function instanceof RankBasedPreferenceSorting) {
            return new RankBasedPreferenceSorting();
        }
        throw new IllegalArgumentException("cannot adapt ranking function " + function);
    }

    @Override
    public final void setBloatControl(BloatControlFunction<TestSuiteChromosome> bcf) {
        ((GeneticAlgorithm)this.algorithm).setBloatControl(this.mapBloatControlToTestLevel(bcf));
    }

    @Override
    public void addBloatControl(BloatControlFunction<TestSuiteChromosome> bloatControl) {
        if (this.algorithm != null) {
            ((GeneticAlgorithm)this.algorithm).setBloatControl(this.mapBloatControlToTestLevel(bloatControl));
        }
    }

    private BloatControlFunction<TestChromosome> mapBloatControlToTestLevel(BloatControlFunction<TestSuiteChromosome> bloatControl) {
        if (bloatControl instanceof RelativeSuiteLengthBloatControl) {
            RelativeSuiteLengthBloatControl bcf = (RelativeSuiteLengthBloatControl)bloatControl;
            return new RelativeSuiteLengthBloatControl<TestChromosome>(bcf);
        }
        if (bloatControl instanceof MaxSizeBloatControl) {
            MaxSizeBloatControl bcf = (MaxSizeBloatControl)bloatControl;
            return new MaxSizeBloatControl<TestChromosome>(bcf);
        }
        throw new IllegalArgumentException("cannot adapt bloat control function " + bloatControl);
    }

    @Override
    public final boolean isTooLong(TestSuiteChromosome chromosome) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestSuiteChromosome to TestChromosome conversion for this function not supported");
    }

    @Override
    protected final void calculateFitness() {
        ((GeneticAlgorithm)this.algorithm).calculateFitness();
    }

    @Override
    protected final void calculateFitness(TestSuiteChromosome c) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestSuiteChromosome to TestChromosome conversion for this function not supported");
    }

    @Override
    protected final void calculateFitnessAndSortPopulation() {
        ((GeneticAlgorithm)this.algorithm).calculateFitnessAndSortPopulation();
    }

    @Override
    public final int getPopulationSize() {
        return ((GeneticAlgorithm)this.algorithm).getPopulationSize();
    }

    @Override
    protected final List<TestSuiteChromosome> elitism() {
        return ((GeneticAlgorithm)this.algorithm).elitism().stream().map(TestChromosome::toSuite).collect(Collectors.toList());
    }

    @Override
    protected final List<TestSuiteChromosome> randomism() {
        return ((GeneticAlgorithm)this.algorithm).randomism().stream().map(TestChromosome::toSuite).collect(Collectors.toList());
    }

    @Override
    public final void updateFitnessFunctionsAndValues() {
        ((GeneticAlgorithm)this.algorithm).updateFitnessFunctionsAndValues();
    }

    @Override
    public final void writeIndividuals(List<TestSuiteChromosome> individuals) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestSuiteChromosome to TestChromosome conversion for this function not supported");
    }

    @Override
    public final void setChromosomeFactory(ChromosomeFactory<TestSuiteChromosome> factory) throws IllegalArgumentException {
        if (this.algorithm != null) {
            if (factory instanceof TestSuiteChromosomeFactoryMock) {
                TestSuiteChromosomeFactoryMock tcfw = (TestSuiteChromosomeFactoryMock)factory;
                ((GeneticAlgorithm)this.algorithm).setChromosomeFactory(tcfw.getWrapped());
            } else {
                throw new IllegalArgumentException("factory not supported: " + factory);
            }
        }
    }

    @Override
    public void setCrossOverFunction(CrossOverFunction<TestSuiteChromosome> crossover) throws IllegalArgumentException {
        if (this.algorithm != null) {
            if (crossover instanceof SinglePointRelativeCrossOver) {
                ((GeneticAlgorithm)this.algorithm).setCrossOverFunction(new SinglePointRelativeCrossOver());
            } else {
                if (crossover instanceof CoverageCrossOver) {
                    throw new IllegalArgumentException("CoverageCrossOver not supported");
                }
                if (crossover instanceof UniformCrossOver) {
                    ((GeneticAlgorithm)this.algorithm).setCrossOverFunction(new UniformCrossOver());
                } else if (crossover instanceof SinglePointFixedCrossOver) {
                    ((GeneticAlgorithm)this.algorithm).setCrossOverFunction(new SinglePointFixedCrossOver());
                } else if (crossover instanceof SinglePointCrossOver) {
                    ((GeneticAlgorithm)this.algorithm).setCrossOverFunction(new SinglePointCrossOver());
                } else {
                    throw new IllegalArgumentException("cannot adapt crossover " + crossover);
                }
            }
        }
    }

    @Override
    public void addListener(SearchListener<TestSuiteChromosome> listener) throws IllegalArgumentException {
        if (this.algorithm != null) {
            if (listener instanceof StatisticsListener) {
                super.addListener(listener);
            } else if (listener instanceof RelativeSuiteLengthBloatControl) {
                super.addListener(listener);
            } else if (listener instanceof ResourceController) {
                if (!this.searchListenerMapping.containsKey(listener)) {
                    ResourceController adapteeListener = new ResourceController();
                    this.searchListenerMapping.put(listener, adapteeListener);
                    ((GeneticAlgorithm)this.algorithm).addListener(adapteeListener);
                }
            } else if (listener instanceof ProgressMonitor) {
                super.addListener(listener);
            } else if (listener instanceof ZeroFitnessStoppingCondition) {
                super.addListener(listener);
            } else {
                throw new IllegalArgumentException("cannot adapt listener " + listener);
            }
        }
    }

    @Override
    public final void removeListener(SearchListener<TestSuiteChromosome> listener) {
        super.removeListener(listener);
        if (this.algorithm != null) {
            if (listener instanceof StatisticsListener) {
                super.removeListener(listener);
            } else if (listener instanceof RelativeSuiteLengthBloatControl) {
                super.removeListener(listener);
            } else if (listener instanceof ResourceController) {
                if (this.searchListenerMapping.containsKey(listener)) {
                    ((GeneticAlgorithm)this.algorithm).removeListener(this.searchListenerMapping.get(listener));
                }
            } else if (listener instanceof ProgressMonitor) {
                super.removeListener(listener);
            } else if (listener instanceof ZeroFitnessStoppingCondition) {
                super.removeListener(listener);
            } else {
                throw new IllegalArgumentException("cannot adapt listener " + listener);
            }
        }
    }

    @Override
    public final void notifySearchStarted() {
        super.notifySearchStarted();
    }

    @Override
    public final void notifySearchFinished() {
        super.notifySearchFinished();
    }

    @Override
    public final void notifyIteration() {
        super.notifyIteration();
    }

    @Override
    protected final void sortPopulation() {
        ((GeneticAlgorithm)this.algorithm).sortPopulation();
    }

    @Override
    public final List<TestSuiteChromosome> getPopulation() {
        return Collections.singletonList(((GeneticAlgorithm)this.algorithm).getPopulation().stream().collect(TestChromosome.toTestSuiteCollector));
    }

    @Override
    public final boolean isNextPopulationFull(List<TestSuiteChromosome> nextGeneration) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("TestSuiteChromosome to TestChromosome conversion for this function not supported");
    }

    @Override
    public void setPopulationLimit(PopulationLimit<TestSuiteChromosome> limit) throws IllegalArgumentException {
        if (this.algorithm != null) {
            ((GeneticAlgorithm)this.algorithm).setPopulationLimit(TestSuiteAdapter.mapPopulationLimit(limit));
        }
    }

    private static <T extends Chromosome<T>> PopulationLimit<T> mapPopulationLimit(PopulationLimit<?> limit) {
        if (limit instanceof IndividualPopulationLimit) {
            return new IndividualPopulationLimit((IndividualPopulationLimit)limit);
        }
        if (limit instanceof StatementsPopulationLimit) {
            return new StatementsPopulationLimit((StatementsPopulationLimit)limit);
        }
        if (limit instanceof SizePopulationLimit) {
            return new SizePopulationLimit((SizePopulationLimit)limit);
        }
        throw new IllegalArgumentException("cannot adapt population limit " + limit);
    }

    @Override
    public final boolean isFinished() {
        return ((GeneticAlgorithm)this.algorithm).isFinished();
    }

    @Override
    public void addStoppingCondition(StoppingCondition<TestSuiteChromosome> condition) throws IllegalArgumentException {
        if (this.algorithm != null) {
            ((GeneticAlgorithm)this.algorithm).addStoppingCondition(TestSuiteAdapter.mapStoppingCondition(condition));
        }
    }

    @Override
    public final Set<StoppingCondition<TestSuiteChromosome>> getStoppingConditions() {
        return ((GeneticAlgorithm)this.algorithm).getStoppingConditions().stream().map(TestSuiteAdapter::mapStoppingCondition).collect(Collectors.toSet());
    }

    private static <T extends Chromosome<T>> StoppingCondition<T> mapStoppingCondition(StoppingCondition<?> stoppingCondition) {
        if (stoppingCondition instanceof MaxTimeStoppingCondition) {
            return new MaxTimeStoppingCondition((MaxTimeStoppingCondition)stoppingCondition);
        }
        if (stoppingCondition instanceof MaxGenerationStoppingCondition) {
            return new MaxGenerationStoppingCondition((MaxGenerationStoppingCondition)stoppingCondition);
        }
        if (stoppingCondition instanceof RMIStoppingCondition) {
            return RMIStoppingCondition.getInstance();
        }
        if (stoppingCondition instanceof ShutdownTestWriter) {
            return new ShutdownTestWriter((ShutdownTestWriter)stoppingCondition);
        }
        if (stoppingCondition instanceof MaxStatementsStoppingCondition) {
            return new MaxStatementsStoppingCondition((MaxStatementsStoppingCondition)stoppingCondition);
        }
        if (stoppingCondition instanceof GlobalTimeStoppingCondition) {
            return new GlobalTimeStoppingCondition((GlobalTimeStoppingCondition)stoppingCondition);
        }
        if (stoppingCondition instanceof SocketStoppingCondition) {
            return SocketStoppingCondition.getInstance();
        }
        if (stoppingCondition instanceof ZeroFitnessStoppingCondition) {
            return new ZeroFitnessStoppingCondition((ZeroFitnessStoppingCondition)stoppingCondition);
        }
        throw new IllegalArgumentException("cannot adapt stopping condition: " + stoppingCondition);
    }

    @Override
    public void setStoppingCondition(StoppingCondition<TestSuiteChromosome> condition) {
        ((GeneticAlgorithm)this.algorithm).setStoppingCondition(TestSuiteAdapter.mapStoppingCondition(condition));
    }

    @Override
    public final void removeStoppingCondition(StoppingCondition<TestSuiteChromosome> condition) {
        ((GeneticAlgorithm)this.algorithm).removeStoppingCondition(TestSuiteAdapter.mapStoppingCondition(condition));
    }

    @Override
    public void resetStoppingConditions() {
        ((GeneticAlgorithm)this.algorithm).resetStoppingConditions();
    }

    @Override
    public final void setStoppingConditionLimit(int value) {
        ((GeneticAlgorithm)this.algorithm).setStoppingConditionLimit(value);
    }

    @Override
    protected final void updateBestIndividualFromArchive() {
        ((GeneticAlgorithm)this.algorithm).updateBestIndividualFromArchive();
    }

    @Override
    protected final boolean isBetterOrEqual(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public final void printBudget() {
        ((GeneticAlgorithm)this.algorithm).printBudget();
    }

    @Override
    public final String getBudgetString() {
        return ((GeneticAlgorithm)this.algorithm).getBudgetString();
    }

    @Override
    protected final double progress() {
        return ((GeneticAlgorithm)this.algorithm).progress();
    }

    @Override
    public List getFitnessFunctions() {
        return ((GeneticAlgorithm)this.algorithm).getFitnessFunctions();
    }

    private static FitnessFunction<TestChromosome> mapFitnessFunctionToTestCaseLevel(FitnessFunction<TestSuiteChromosome> fitnessFunction) throws IllegalArgumentException {
        if (fitnessFunction instanceof TestSuiteFitnessFunctionMock) {
            return ((TestSuiteFitnessFunctionMock)fitnessFunction).getWrapped();
        }
        throw new IllegalArgumentException("Unsupported type of fitness function: " + fitnessFunction.getClass());
    }

    @Override
    public void addFitnessFunctions(Collection<? extends FitnessFunction<TestSuiteChromosome>> functions) {
        Collection fs = functions.stream().map(TestSuiteAdapter::mapFitnessFunctionToTestCaseLevel).collect(Collectors.toList());
        ((GeneticAlgorithm)this.algorithm).addFitnessFunctions(fs);
    }

    @Override
    public String toString() {
        if (this.algorithm == null) {
            return "TestSuiteAdapter under construction";
        }
        return ((GeneticAlgorithm)this.algorithm).toString();
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private static class TestSuiteFitnessFunctionWrapper
    extends TestSuiteFitnessFunction {
        private static final long serialVersionUID = 5136258490569674883L;
        private final boolean maximizationFunction;

        TestSuiteFitnessFunctionWrapper(FitnessFunction<TestChromosome> fitnessFunction) {
            this.maximizationFunction = fitnessFunction.isMaximizationFunction();
        }

        @Override
        public double getFitness(TestSuiteChromosome individual) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("cannot apply wrapped TestFitnessFunction to TestSuiteChromosome");
        }

        @Override
        public boolean isMaximizationFunction() {
            return this.maximizationFunction;
        }
    }
}

