/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mapelites;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Inspector;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.mapelites.FeatureVector;
import org.evosuite.ga.metaheuristics.mapelites.FitnessFunctionWrapper;
import org.evosuite.ga.metaheuristics.mapelites.TestResultObserver;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.IterUtil;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MAPElites
extends GeneticAlgorithm<TestChromosome> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(MAPElites.class);
    private final Map<FitnessFunctionWrapper, Map<FeatureVector, TestChromosome>> populationMap;
    private final Set<FeatureVector> droppedFeatureVectors;
    private final int featureVectorPossibilityCount;
    private final int featureCount;
    private final List<TestChromosome> bestIndividuals;
    private static final List<FeatureVector> IGNORE_VECTORS = Arrays.asList(new FeatureVector(new Inspector[0], null));
    private final CrossOverFunction<TestChromosome> crossoverFunction = new SinglePointCrossOver<TestChromosome>();

    public MAPElites(ChromosomeFactory<TestChromosome> factory) {
        super(factory);
        this.bestIndividuals = new LinkedList<TestChromosome>();
        this.droppedFeatureVectors = new LinkedHashSet<FeatureVector>();
        TestResultObserver observer = new TestResultObserver();
        this.featureVectorPossibilityCount = observer.getPossibilityCount();
        this.featureCount = observer.getFeatureVectorLength();
        TestCaseExecutor.getInstance().addObserver(observer);
        this.populationMap = new LinkedHashMap<FitnessFunctionWrapper, Map<FeatureVector, TestChromosome>>();
    }

    public void addTestFitnessFunctions(List<TestFitnessFunction> functions) {
        for (TestFitnessFunction function : functions) {
            this.populationMap.put(new FitnessFunctionWrapper(function), new LinkedHashMap());
            this.addFitnessFunction(function);
        }
    }

    private Set<TestChromosome> getToMutateWithChance() {
        LinkedHashSet<TestChromosome> toMutate = new LinkedHashSet<TestChromosome>(1);
        List<FitnessFunctionWrapper> minima = this.getMinimalBranches();
        double chance = 1.0 / (double)minima.size();
        for (FitnessFunctionWrapper branch : minima) {
            if (!(Randomness.nextDouble() <= chance)) continue;
            branch.getCounter().increment();
            TestChromosome chromosome = Randomness.choice(this.populationMap.get(branch).values());
            if (chromosome == null) continue;
            toMutate.add(chromosome);
        }
        return toMutate;
    }

    private Set<TestChromosome> getToMutateAll() {
        LinkedHashSet<TestChromosome> toMutate = new LinkedHashSet<TestChromosome>(this.populationMap.values().size());
        for (Map<FeatureVector, TestChromosome> entry : this.populationMap.values()) {
            TestChromosome chromosome = Randomness.choice(entry.values());
            if (chromosome == null) continue;
            toMutate.add(chromosome);
        }
        return toMutate;
    }

    private List<FitnessFunctionWrapper> getMinimalBranches() {
        return IterUtil.minList(this.populationMap.keySet(), Comparator.comparing(FitnessFunctionWrapper::getCounter));
    }

    private Set<TestChromosome> getToMutateRandom() {
        LinkedHashSet<TestChromosome> toMutate = new LinkedHashSet<TestChromosome>(1);
        List<FitnessFunctionWrapper> minima = this.getMinimalBranches();
        FitnessFunctionWrapper selectedBranch = Randomness.choice(minima);
        if (selectedBranch == null) {
            return toMutate;
        }
        selectedBranch.getCounter().increment();
        Map<FeatureVector, TestChromosome> entry = this.populationMap.get(selectedBranch);
        TestChromosome chromosome = Randomness.choice(entry.values());
        if (chromosome != null) {
            toMutate.add(chromosome);
        }
        return toMutate;
    }

    private Set<TestChromosome> getToMutate() {
        switch (Properties.MAP_ELITES_CHOICE) {
            case ALL: {
                return this.getToMutateAll();
            }
            case SINGLE: {
                return this.getToMutateRandom();
            }
        }
        return this.getToMutateWithChance();
    }

    private void applyMutation(TestChromosome chromosome, TestChromosome parent) {
        this.removeUnusedVariables(chromosome);
        if (Properties.MAP_ELITES_MOSA_MUTATIONS) {
            this.mutate(chromosome, parent);
        } else {
            this.notifyMutation(chromosome);
            chromosome.mutate();
        }
        if (chromosome.isChanged() && !this.isTooLong(chromosome)) {
            this.analyzeChromosome(chromosome);
        }
    }

    @Override
    protected void evolve() {
        Set<TestChromosome> parents1 = this.getToMutate();
        Set<TestChromosome> parents2 = this.getToMutate();
        LinkedHashSet toMutate = new LinkedHashSet();
        for (TestChromosome parent1 : parents1) {
            TestChromosome offspring1 = parent1.clone();
            if (parents2.size() > 0 && Randomness.nextDouble() <= Properties.CROSSOVER_RATE) {
                TestChromosome parent2 = Randomness.choice(parents2);
                TestChromosome offspring2 = parent2.clone();
                try {
                    this.crossoverFunction.crossOver(offspring1, offspring2);
                }
                catch (ConstructionFailedException e) {
                    logger.debug("CrossOver failed.");
                    continue;
                }
                this.applyMutation(offspring2, parent2);
            }
            this.applyMutation(offspring1, parent1);
        }
        if (toMutate.isEmpty() && Properties.MAP_ELITES_CHOICE != Properties.MapElitesChoice.SINGLE_AVG || Randomness.nextDouble() <= Properties.MAP_ELITES_RANDOM) {
            this.analyzeChromosome((TestChromosome)this.getRandomPopulation(1).get(0));
        }
        ++this.currentIteration;
    }

    private void mutate(TestChromosome offspring, TestChromosome parent) {
        offspring.mutate();
        if (!offspring.isChanged()) {
            offspring.mutate();
        }
        if (!this.hasMethodCall(offspring)) {
            offspring.setTestCase(parent.getTestCase().clone());
            boolean changed = offspring.mutationInsert();
            if (changed) {
                for (Statement s : offspring.getTestCase()) {
                    s.isValid();
                }
            }
            offspring.setChanged(changed);
        }
        this.notifyMutation(offspring);
    }

    private boolean hasMethodCall(TestChromosome test) {
        boolean flag = false;
        TestCase tc = test.getTestCase();
        for (Statement s : tc) {
            EntityWithParametersStatement ms;
            boolean isTargetMethod;
            if (s instanceof MethodStatement && (isTargetMethod = ((MethodStatement)(ms = (MethodStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) {
                return true;
            }
            if (!(s instanceof ConstructorStatement) || !(isTargetMethod = ((ConstructorStatement)(ms = (ConstructorStatement)s)).getDeclaringClassName().equals(Properties.TARGET_CLASS))) continue;
            return true;
        }
        return flag;
    }

    private boolean removeUnusedVariables(TestChromosome chromosome) {
        int sizeBefore = chromosome.size();
        TestCase t = chromosome.getTestCase();
        ArrayList<Integer> to_delete = new ArrayList<Integer>(chromosome.size());
        boolean has_deleted = false;
        int num = 0;
        for (Statement s : t) {
            VariableReference var = s.getReturnValue();
            boolean delete = false;
            delete = delete || s instanceof PrimitiveStatement;
            delete = delete || s instanceof ArrayStatement;
            boolean bl = delete = delete || s instanceof StringPrimitiveStatement;
            if (!t.hasReferences(var) && delete) {
                to_delete.add(num);
                has_deleted = true;
            }
            ++num;
        }
        to_delete.sort(Collections.reverseOrder());
        for (Integer position : to_delete) {
            t.remove(position);
        }
        int sizeAfter = chromosome.size();
        if (has_deleted) {
            logger.debug("Removed {} unused statements", (Object)(sizeBefore - sizeAfter));
        }
        return has_deleted;
    }

    private int getFoundVectorCount() {
        LinkedHashSet<FeatureVector> vectors = new LinkedHashSet<FeatureVector>();
        this.populationMap.values().forEach(entry -> vectors.addAll(entry.keySet()));
        vectors.addAll(this.droppedFeatureVectors);
        return vectors.size();
    }

    private void sendFeatureData() {
        int foundVectorCount = this.getFoundVectorCount();
        double density = this.getDensity(foundVectorCount);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.DensityTimeline, density);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.FeaturesFound, foundVectorCount);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.FeaturePartitionCount, this.featureVectorPossibilityCount);
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.FeatureCount, this.featureCount);
    }

    private double getDensity(int foundVectorCount) {
        int n = this.featureVectorPossibilityCount;
        int z = this.getFoundVectorCount();
        double density = (double)z / (double)n;
        return density;
    }

    private void analyzeChromosome(TestChromosome chromosome) {
        Iterator<Map.Entry<FitnessFunctionWrapper, Map<FeatureVector, TestChromosome>>> it = this.populationMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FitnessFunctionWrapper, Map<FeatureVector, TestChromosome>> entry = it.next();
            FitnessFunctionWrapper branchFitness = entry.getKey();
            Map<FeatureVector, TestChromosome> featureMap = entry.getValue();
            double fitness = branchFitness.getFitness(chromosome);
            List<FeatureVector> features = Properties.MAP_ELITES_IGNORE_FEATURES ? IGNORE_VECTORS : chromosome.getLastExecutionResult().getFeatureVectors();
            for (FeatureVector feature : features) {
                TestChromosome old = featureMap.get(feature);
                if (old != null && !(branchFitness.getFitness(old) >= fitness)) continue;
                featureMap.put(feature, chromosome);
                branchFitness.getCounter().reset();
            }
            if (!branchFitness.isCovered(chromosome)) continue;
            it.remove();
            this.droppedFeatureVectors.addAll(featureMap.keySet());
            this.bestIndividuals.add(chromosome);
        }
    }

    @Override
    public void initializePopulation() {
        this.notifySearchStarted();
        this.currentIteration = 0;
        List population = this.getRandomPopulation(Properties.POPULATION);
        if (population.isEmpty()) {
            throw new IllegalStateException();
        }
        for (TestChromosome chromosome : population) {
            this.analyzeChromosome(chromosome);
        }
    }

    @Override
    public TestChromosome getBestIndividual() {
        if (this.bestIndividuals.isEmpty()) {
            return (TestChromosome)this.chromosomeFactory.getChromosome();
        }
        return this.bestIndividuals.get(0);
    }

    @Override
    public List<TestChromosome> getBestIndividuals() {
        throw new UnsupportedOperationException();
    }

    private void updateAndSortBest() {
        for (Map<FeatureVector, TestChromosome> branch : this.populationMap.values()) {
            this.bestIndividuals.addAll(branch.values());
        }
        if (this.isMaximizationFunction()) {
            this.bestIndividuals.sort(Collections.reverseOrder());
        } else {
            Collections.sort(this.bestIndividuals);
        }
    }

    @Override
    public List<TestChromosome> getPopulation() {
        return this.bestIndividuals;
    }

    @Override
    public void generateSolution() {
        this.initializePopulation();
        this.sendFeatureData();
        while (!this.isFinished()) {
            this.evolve();
            this.sendFeatureData();
            this.notifyIteration();
        }
        this.updateAndSortBest();
        this.notifySearchFinished();
    }
}

