/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mosa.structural;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.ga.metaheuristics.mosa.structural.DependencyEdge;
import org.evosuite.graphs.cfg.ActualControlFlowGraph;
import org.evosuite.graphs.cfg.BasicBlock;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.evosuite.testcase.TestFitnessFunction;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchFitnessGraph
implements Serializable {
    private static final long serialVersionUID = -8020578778906420503L;
    private static final Logger logger = LoggerFactory.getLogger(BranchFitnessGraph.class);
    protected DefaultDirectedGraph<TestFitnessFunction, DependencyEdge> graph = new DefaultDirectedGraph(DependencyEdge.class);
    protected Set<TestFitnessFunction> rootBranches = new HashSet<TestFitnessFunction>();

    public BranchFitnessGraph(Set<TestFitnessFunction> goals) {
        goals.forEach(g -> this.graph.addVertex((TestFitnessFunction)g));
        for (TestFitnessFunction fitness : goals) {
            Branch branch = ((BranchCoverageTestFitness)fitness).getBranch();
            if (branch == null) {
                this.rootBranches.add(fitness);
                continue;
            }
            if (branch.getInstruction().isRootBranchDependent()) {
                this.rootBranches.add(fitness);
            }
            ActualControlFlowGraph rcfg = branch.getInstruction().getActualCFG();
            HashSet<BasicBlock> visitedBlock = new HashSet<BasicBlock>();
            Set<BasicBlock> parents = this.lookForParent(branch.getInstruction().getBasicBlock(), rcfg, visitedBlock);
            for (BasicBlock bb : parents) {
                Branch newB = this.extractBranch(bb);
                if (newB == null) {
                    this.rootBranches.add(fitness);
                    continue;
                }
                BranchCoverageGoal goal = new BranchCoverageGoal(newB, true, newB.getClassName(), newB.getMethodName());
                BranchCoverageTestFitness newFitness = new BranchCoverageTestFitness(goal);
                this.graph.addEdge(newFitness, fitness);
                BranchCoverageGoal goal2 = new BranchCoverageGoal(newB, false, newB.getClassName(), newB.getMethodName());
                BranchCoverageTestFitness newfitness2 = new BranchCoverageTestFitness(goal2);
                this.graph.addEdge(newfitness2, fitness);
            }
        }
    }

    public Set<BasicBlock> lookForParent(BasicBlock block, ActualControlFlowGraph acfg, Set<BasicBlock> visitedBlock) {
        HashSet<BasicBlock> realParent = new HashSet<BasicBlock>();
        Set<BasicBlock> parents = acfg.getParents(block);
        if (parents.size() == 0) {
            realParent.add(block);
            return realParent;
        }
        for (BasicBlock bb : parents) {
            if (visitedBlock.contains(bb)) continue;
            visitedBlock.add(bb);
            if (this.containsBranches(bb)) {
                realParent.add(bb);
                continue;
            }
            realParent.addAll(this.lookForParent(bb, acfg, visitedBlock));
        }
        return realParent;
    }

    public boolean containsBranches(BasicBlock block) {
        for (BytecodeInstruction inst : block) {
            if (inst.toBranch() == null) continue;
            return true;
        }
        return false;
    }

    public Branch extractBranch(BasicBlock block) {
        for (BytecodeInstruction inst : block) {
            if (!inst.isBranch() && !inst.isActualBranch()) continue;
            return inst.toBranch();
        }
        return null;
    }

    public Set<TestFitnessFunction> getRootBranches() {
        return this.rootBranches;
    }

    public Set<TestFitnessFunction> getStructuralChildren(TestFitnessFunction parent) {
        return this.graph.outgoingEdgesOf(parent).stream().map(DependencyEdge::getTarget).collect(Collectors.toSet());
    }

    public Set<TestFitnessFunction> getStructuralParents(TestFitnessFunction parent) {
        return this.graph.incomingEdgesOf(parent).stream().map(DependencyEdge::getSource).collect(Collectors.toSet());
    }
}

