/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import java.util.ArrayList;
import java.util.Collections;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.metaheuristics.mulambda.AbstractMuLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MuLambdaEA<T extends Chromosome<T>>
extends AbstractMuLambda<T> {
    private static final long serialVersionUID = -1104094637643130537L;
    private static final Logger logger = LoggerFactory.getLogger(MuLambdaEA.class);

    public MuLambdaEA(ChromosomeFactory<T> factory, int mu, int lambda) {
        super(factory, mu, lambda);
    }

    @Override
    protected void evolve() {
        ArrayList<Object> offspring = new ArrayList<Object>(this.lambda);
        for (int i = 0; i < this.mu; ++i) {
            for (int j = 0; j < this.lambda / this.mu; ++j) {
                Object t = ((Chromosome)this.population.get(i)).clone();
                do {
                    this.notifyMutation(t);
                    ((Chromosome)t).mutate();
                } while (!((Chromosome)t).isChanged());
                offspring.add(t);
            }
        }
        for (Chromosome chromosome : offspring) {
            for (FitnessFunction fitnessFunction : this.fitnessFunctions) {
                fitnessFunction.getFitness(chromosome);
                this.notifyEvaluation(chromosome);
            }
        }
        if (this.getFitnessFunction().isMaximizationFunction()) {
            offspring.sort(Collections.reverseOrder());
        } else {
            Collections.sort(offspring);
        }
        for (int i = 0; i < this.population.size(); ++i) {
            logger.debug("replacing " + ((Chromosome)this.population.get(i)).getFitness() + " with " + ((Chromosome)offspring.get(i)).getFitness());
            this.population.set(i, offspring.get(i));
        }
    }
}

