/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.metaheuristics.mulambda;

import java.util.ArrayList;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.metaheuristics.mulambda.AbstractMuLambda;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnePlusLambdaLambdaGA<T extends Chromosome<T>>
extends AbstractMuLambda<T> {
    private static final long serialVersionUID = 529089847512798127L;
    private static final Logger logger = LoggerFactory.getLogger(OnePlusLambdaLambdaGA.class);

    public OnePlusLambdaLambdaGA(ChromosomeFactory<T> factory, int lambda) {
        super(factory, 1, lambda);
    }

    @Override
    protected void evolve() {
        ArrayList<Object> mutants = new ArrayList<Object>();
        Object parent = ((Chromosome)this.population.get(0)).clone();
        while (mutants.size() < this.lambda) {
            Object MutationOffspring = ((Chromosome)parent).clone();
            this.notifyMutation(MutationOffspring);
            ((Chromosome)MutationOffspring).mutate();
            mutants.add(MutationOffspring);
        }
        this.population = mutants;
        this.updateFitnessFunctionsAndValues();
        this.calculateFitnessAndSortPopulation();
        Object bestMutantOffspring = this.getBestIndividual();
        ArrayList<Object> crossoverOffspring = new ArrayList<Object>();
        while (crossoverOffspring.size() < this.lambda) {
            try {
                Object p1 = ((Chromosome)parent).clone();
                Object p2 = ((Chromosome)bestMutantOffspring).clone();
                this.crossoverFunction.crossOver(p1, p2);
                crossoverOffspring.add(p1);
                crossoverOffspring.add(p2);
            }
            catch (ConstructionFailedException e) {
                logger.info("CrossOver failed.");
            }
        }
        this.population = crossoverOffspring;
        this.updateFitnessFunctionsAndValues();
        Object bestCrossoverOffspring = this.getBestIndividual();
        Object so_far_best_individual = this.isBetterOrEqual(bestCrossoverOffspring, parent) ? bestCrossoverOffspring : parent;
        if (this.isBetterOrEqual(so_far_best_individual, bestMutantOffspring)) {
            this.population.set(0, so_far_best_individual);
        } else {
            this.population.set(0, bestMutantOffspring);
        }
        ++this.currentIteration;
    }
}

