/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.crossover;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class CoverageCrossOver
extends CrossOverFunction<TestSuiteChromosome> {
    private static final long serialVersionUID = -2203276450790663024L;

    @Override
    public void crossOver(TestSuiteChromosome parent1, TestSuiteChromosome parent2) throws ConstructionFailedException {
        HashMap<TestFitnessFunction, Set<TestChromosome>> goalMap = new HashMap<TestFitnessFunction, Set<TestChromosome>>();
        this.populateCoverageMap(goalMap, parent1);
        this.populateCoverageMap(goalMap, parent2);
        Set<TestChromosome> unique = this.removeUniqueCoveringTests(goalMap);
        logger.debug("Uniquely covering tests: " + unique.size());
        HashSet<TestChromosome> offspring1 = new HashSet<TestChromosome>();
        HashSet<TestChromosome> offspring2 = new HashSet<TestChromosome>();
        HashSet workingSet = new HashSet();
        for (TestFitnessFunction goal : goalMap.keySet()) {
            workingSet.addAll((Collection)goalMap.get(goal));
        }
        int targetSize = workingSet.size() / 2;
        while (offspring2.size() < targetSize) {
            logger.debug("Sizes: " + workingSet.size() + ", " + offspring1.size() + ", " + offspring2.size());
            TestChromosome choice = (TestChromosome)Randomness.choice(workingSet);
            workingSet.remove(choice);
            offspring2.add(choice);
            offspring1.addAll(this.removeUniqueCoveringTests(goalMap));
        }
        offspring1.addAll(workingSet);
        parent1.clearTests();
        parent2.clearTests();
        for (TestChromosome test : unique) {
            parent1.addTest(test.clone());
            parent2.addTest(test.clone());
        }
        parent1.addTests(offspring1);
        parent2.addTests(offspring2);
        logger.debug("Final sizes: " + parent1.size() + ", " + parent2.size());
    }

    private void populateCoverageMap(Map<TestFitnessFunction, Set<TestChromosome>> goalMap, TestSuiteChromosome suite) {
        for (TestChromosome test : suite.getTestChromosomes()) {
            for (TestFitnessFunction goal : test.getTestCase().getCoveredGoals()) {
                if (!goalMap.containsKey(goal)) {
                    goalMap.put(goal, new HashSet());
                }
                goalMap.get(goal).add(test);
            }
        }
    }

    private Set<TestChromosome> removeUniqueCoveringTests(Map<TestFitnessFunction, Set<TestChromosome>> goalMap) {
        HashSet<TestChromosome> tests = new HashSet<TestChromosome>();
        HashSet<TestFitnessFunction> uniqueGoals = new HashSet<TestFitnessFunction>();
        for (Map.Entry<TestFitnessFunction, Set<TestChromosome>> entry : goalMap.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            uniqueGoals.add(entry.getKey());
            tests.add(entry.getValue().iterator().next());
        }
        uniqueGoals.removeAll(uniqueGoals);
        return tests;
    }
}

