/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.ga.operators.crossover;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.utils.Randomness;

public class UniformCrossOver<T extends Chromosome<T>>
extends CrossOverFunction<T> {
    private static final long serialVersionUID = 2981387570766261795L;

    @Override
    public void crossOver(T parent1, T parent2) throws ConstructionFailedException {
        if (((Chromosome)parent1).size() < 2 || ((Chromosome)parent2).size() < 2) {
            return;
        }
        int maxNumGenes = Math.min(((Chromosome)parent1).size(), ((Chromosome)parent2).size());
        Object t1 = ((Chromosome)parent1).clone();
        Object t2 = ((Chromosome)parent2).clone();
        for (int i = 0; i < maxNumGenes; ++i) {
            if (!(Randomness.nextDouble() <= Properties.CROSSOVER_RATE)) continue;
            ((Chromosome)parent1).crossOver((Object)t2, i);
            ((Chromosome)parent2).crossOver((Object)t1, i);
        }
    }
}

